/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.util;

import java.util.function.LongPredicate;
import net.openhft.chronicle.core.util.LongBiPredicate;
import net.openhft.chronicle.core.util.LongTriPredicate;
import net.openhft.chronicle.core.util.Longs;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Test;

public class LongsTest {
    @Test
    public void require1Arg() {
        this.test(1, 0, v -> Longs.require((LongPredicate)Longs.positive(), (long)v));
        this.test(1, -1, v -> Longs.require((LongPredicate)Longs.positive(), (long)v));
    }

    @Test
    public void require2Arg() {
        this.test(1, 0, v -> Longs.require((LongBiPredicate)Longs.equalTo(), (long)v, (long)1L));
    }

    @Test
    public void require3Ard() {
        this.test(0, 16, v -> Longs.require((LongTriPredicate)Longs.between(), (long)v, (long)0L, (long)16L));
        this.test(15, -1, v -> Longs.require((LongTriPredicate)Longs.between(), (long)v, (long)0L, (long)16L));
    }

    private void test(int happy, int sad, @NotNull LongUnaryOperator mapper) {
        try {
            long result = mapper.applyAsLong(happy);
            Assert.assertEquals((long)happy, (long)result);
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
        try {
            long result2 = mapper.applyAsLong(sad);
            Assert.fail((String)(result2 + " is not valid!"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    static interface LongUnaryOperator {
        public long applyAsLong(int var1) throws IllegalArgumentException;
    }
}

