/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.benchmarks;

import java.security.SecureRandom;
import net.openhft.chronicle.core.Maths;

public class Randomness {
    public static void main(String[] args) {
        long time = 0L;
        long timeCount = 0L;
        long scoreSum = 0L;
        for (int t = 0; t < 500; ++t) {
            long[] hashs = new long[8192];
            StringBuilder sb = new StringBuilder();
            byte[] init = new byte[hashs.length / 64];
            new SecureRandom().nextBytes(init);
            for (int i = 0; i < hashs.length; ++i) {
                sb.setLength(0);
                sb.append(t).append('-').append(i);
                long start = System.nanoTime();
                hashs[i] = Maths.hash64((StringBuilder)sb);
                time += System.nanoTime() - start;
                ++timeCount;
            }
            long score = 0L;
            for (int i = 0; i < hashs.length - 1; ++i) {
                for (int j = i + 1; j < hashs.length; ++j) {
                    long diff = hashs[j] ^ hashs[i];
                    int diffBC = Long.bitCount(diff);
                    if (diffBC >= 18) continue;
                    long d = 1L << 17 - diffBC;
                    score += d;
                }
            }
            scoreSum += score;
        }
        System.out.println("Average score: " + scoreSum / 500L);
        System.out.printf("Average time %.3f us%n", (double)(time / timeCount) / 1000.0);
    }
}

