/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.io;

import java.util.concurrent.atomic.AtomicInteger;
import net.openhft.chronicle.core.io.MonitorReferenceCountedContractTest;
import net.openhft.chronicle.core.io.ReferenceOwner;
import net.openhft.chronicle.core.io.VanillaReferenceCounted;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class VanillaReferenceCountedTest
extends MonitorReferenceCountedContractTest {
    private AtomicInteger onReleasedCallCount;

    @Before
    public void setUp() {
        this.onReleasedCallCount = new AtomicInteger(0);
    }

    protected VanillaReferenceCounted createReferenceCounted() {
        return new VanillaReferenceCounted(this.onReleasedCallCount::incrementAndGet, VanillaReferenceCounted.class);
    }

    @Test
    public void createdHereWillReturnNull() {
        VanillaReferenceCounted referenceCounted = this.createReferenceCounted();
        Assert.assertNull((Object)referenceCounted.createdHere());
    }

    @Test
    public void reservedByWillThrowWhenResourceHasBeenReleased() {
        VanillaReferenceCounted referenceCounted = this.createReferenceCounted();
        referenceCounted.releaseLast();
        ReferenceOwner a = ReferenceOwner.temporary((String)"a");
        Assert.assertThrows(IllegalStateException.class, () -> referenceCounted.reservedBy(a));
    }

    @Test
    public void reservedByWillReturnTrueWheneverThereAreAnyReferencesHeld() {
        VanillaReferenceCounted referenceCounted = this.createReferenceCounted();
        ReferenceOwner a = ReferenceOwner.temporary((String)"a");
        Assert.assertTrue((boolean)referenceCounted.reservedBy(a));
        ReferenceOwner b = ReferenceOwner.temporary((String)"b");
        Assert.assertTrue((boolean)referenceCounted.reservedBy(b));
        referenceCounted.releaseLast();
    }
}

