/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.internal;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.onoes.ExceptionKey;
import net.openhft.chronicle.core.onoes.LogLevel;
import net.openhft.chronicle.testframework.internal.ExceptionTracker;

public enum JvmExceptionTracker {

    private static final Set<LogLevel> IGNORED_LOG_LEVELS = EnumSet.of(LogLevel.DEBUG, LogLevel.PERF);

    public static ExceptionTracker<ExceptionKey> create() {
        return JvmExceptionTracker.create(Jvm.recordExceptions());
    }

    public static ExceptionTracker<ExceptionKey> create(boolean debug) {
        return JvmExceptionTracker.create(Jvm.recordExceptions((boolean)debug));
    }

    public static ExceptionTracker<ExceptionKey> create(boolean debug, boolean exceptionsOnly) {
        return JvmExceptionTracker.create(Jvm.recordExceptions((boolean)debug, (boolean)exceptionsOnly));
    }

    public static ExceptionTracker<ExceptionKey> create(boolean debug, boolean exceptionsOnly, boolean logToSlf4j) {
        return JvmExceptionTracker.create(Jvm.recordExceptions((boolean)debug, (boolean)exceptionsOnly, (boolean)logToSlf4j));
    }

    private static ExceptionTracker<ExceptionKey> create(Map<ExceptionKey, Integer> recordedExceptions) {
        return ExceptionTracker.create(ExceptionKey::message, ExceptionKey::throwable, Jvm::resetExceptionHandlers, recordedExceptions, key -> IGNORED_LOG_LEVELS.contains(key.level()), key -> key.level() + " " + key.clazz().getSimpleName() + " " + key.message());
    }
}

