/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.io;

import net.openhft.chronicle.core.io.MonitorReferenceCounted;
import net.openhft.chronicle.core.io.ReferenceCountedTracerContractTest;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public abstract class MonitorReferenceCountedContractTest
extends ReferenceCountedTracerContractTest {
    protected abstract MonitorReferenceCounted createReferenceCounted();

    @Test
    public void warnAndReleaseWillLogAWarningAndReleaseWhenMonitored() {
        MonitorReferenceCounted referenceCounted = this.createReferenceCounted();
        referenceCounted.unmonitored(false);
        referenceCounted.warnAndReleaseIfNotReleased();
        Assertions.assertEquals((int)0, (int)referenceCounted.refCount());
        this.expectException("Discarded without being released");
    }

    @Test
    public void warnAndReleaseWillJustReleaseWhenMonitored() {
        MonitorReferenceCounted referenceCounted = this.createReferenceCounted();
        referenceCounted.unmonitored(true);
        referenceCounted.warnAndReleaseIfNotReleased();
        Assertions.assertEquals((int)0, (int)referenceCounted.refCount());
    }

    @Test
    public void warnAndReleaseWillDoNothingIfTheResourceIsAlreadyReleased() {
        MonitorReferenceCounted referenceCounted = this.createReferenceCounted();
        referenceCounted.unmonitored(false);
        referenceCounted.releaseLast();
        referenceCounted.warnAndReleaseIfNotReleased();
    }
}

