/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.io;

import java.util.Random;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.core.cooler.CoolerTester;
import net.openhft.chronicle.core.cooler.CpuCooler;
import net.openhft.chronicle.core.cooler.CpuCoolers;
import net.openhft.chronicle.core.io.UnsafeText;
import org.junit.Assert;
import org.junit.Test;

public class UnsafeTextTest {
    static long blackhole;
    static final int max = 32;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void coolerAppendBase10quick() {
        long address = UnsafeMemory.UNSAFE.allocateMemory(32L);
        try {
            new CoolerTester(new CpuCooler[]{CpuCoolers.PAUSE1, CpuCoolers.BUSY1}).add("20d", () -> {
                blackhole = UnsafeText.appendFixed((long)address, (long)-2147483647L);
                return null;
            }).runTimeMS(100).repeat(3).run();
            String memVal = LongStream.range(address, blackhole).mapToInt(addr -> UnsafeMemory.UNSAFE.getByte(null, addr)).mapToObj(c -> Character.valueOf((char)c)).reduce(new StringBuilder(), StringBuilder::append, StringBuilder::append).toString();
            Assert.assertEquals((Object)Long.toString(-2147483647L), (Object)memVal);
        }
        finally {
            UnsafeMemory.UNSAFE.freeMemory(address);
        }
    }

    @Test
    public void testAppendDouble() {
        this.testAppendDoubleOnce(5.959231521092378E-8, "5.959231521092378E-8");
        this.testAppendDoubleOnce(5.954710747053357E-8, "5.954710747053357E-8");
        this.testAppendDoubleOnce(-4.3723721608241563E-8, "-4.3723721608241563E-8");
        this.testAppendDoubleOnce(3.5645738448792343E-8, "3.5645738448792343E-8");
        this.testAppendDoubleOnce(1.1914579369762811E-8, "1.1914579369762811E-8");
        this.testAppendDoubleOnce(-1.4778838950354771E-9, "-1.4778838950354771E-9");
        this.testAppendDoubleOnce(-1.4534486891380002E11, "-145344868913.80003");
        this.testAppendDoubleOnce(1.4753448053710411E-8, "1.4753448053710411E-8");
        this.testAppendDoubleOnce(4.731428525883379E-10, "4.731428525883379E-10");
        this.testAppendDoubleOnce(1.0E-5, "0.00001");
        this.testAppendDoubleOnce(5.7270847085938394E-9, "5.7270847085938394E-9");
        this.testAppendDoubleOnce(-3.5627763205104632E-9, "-3.5627763205104632E-9");
        this.testAppendDoubleOnce(3.4363211797092447E-10, "3.4363211797092447E-10");
        this.testAppendDoubleOnce(0.9123456789012345, "0.9123456789012345");
        this.testAppendDoubleOnce(0.7205789375929972, "0.7205789375929972");
        this.testAppendDoubleOnce(1.7205789375929972E-8, "1.7205789375929972E-8");
        this.testAppendDoubleOnce(1.000000459754255, "1.000000459754255");
        this.testAppendDoubleOnce(-0.0042633243189823394, "-0.0042633243189823394");
        this.testAppendDoubleOnce(4.3634067645459027E-4, "0.00043634067645459027");
        this.testAppendDoubleOnce(-4.8378951079402273E-4, "-0.00048378951079402273");
        this.testAppendDoubleOnce(3.8098893793449994E-4, "0.00038098893793449994");
        this.testAppendDoubleOnce(-0.0036980489197619678, "-0.0036980489197619678");
        this.testAppendDoubleOnce(1.1777536373898703E-7, "0.00000011777536373898703");
        this.testAppendDoubleOnce(8.577881719106565E-8, "0.00000008577881719106565");
        this.testAppendDoubleOnce(1.1709707236415293E-7, "0.00000011709707236415293");
        this.testAppendDoubleOnce(1.0272238286878982E-7, "0.00000010272238286878982");
        this.testAppendDoubleOnce(9.077547054210796E-8, "0.00000009077547054210796");
        this.testAppendDoubleOnce(-1.1914407211387385E-7, "-0.00000011914407211387385");
        this.testAppendDoubleOnce(8.871684275243539E-4, "0.0008871684275243539");
        this.testAppendDoubleOnce(8.807878708605213E-4, "0.0008807878708605213");
        this.testAppendDoubleOnce(8.417670165790972E-4, "0.0008417670165790972");
        this.testAppendDoubleOnce(0.0013292726996348332, "0.0013292726996348332");
        this.testAppendDoubleOnce(2.4192540417349368E-4, "0.00024192540417349368");
        this.testAppendDoubleOnce(1.9283711356548258E-4, "0.00019283711356548258");
        this.testAppendDoubleOnce(-8.299137873077923E-5, "-0.00008299137873077923");
        this.testAppendDoubleOnce(0.0, "0.0");
        this.testAppendDoubleOnce(0.001, "0.001");
        this.testAppendDoubleOnce(1.0E-4, "0.0001");
        this.testAppendDoubleOnce(1.0E-6, "0.000001");
        this.testAppendDoubleOnce(1.0E-7, "0.0000001");
        this.testAppendDoubleOnce(1.0E-8, "1.0E-8");
        this.testAppendDoubleOnce(1.0E-9, "1.0E-9");
        this.testAppendDoubleOnce(0.009, "0.009");
        this.testAppendDoubleOnce(9.0E-4, "0.0009");
        this.testAppendDoubleOnce(9.0E-5, "0.00009");
        this.testAppendDoubleOnce(9.0E-6, "0.000009");
        this.testAppendDoubleOnce(9.0E-7, "0.0000009");
        this.testAppendDoubleOnce(9.0E-8, "0.00000009");
        this.testAppendDoubleOnce(9.0E-9, "9.0E-9");
        this.testAppendDoubleOnce(Double.NaN, "NaN");
        this.testAppendDoubleOnce(Double.POSITIVE_INFINITY, "Infinity");
        this.testAppendDoubleOnce(Double.NEGATIVE_INFINITY, "-Infinity");
        this.testAppendDoubleOnce(0.1, "0.1");
        this.testAppendDoubleOnce(12.0, "12.0");
        this.testAppendDoubleOnce(12.1, "12.1");
        this.testAppendDoubleOnce(12.00000001, "12.00000001");
        this.testAppendDoubleOnce(1.0E-9 + Math.ulp(1.0E-9), "1.0000000000000003E-9");
        this.testAppendDoubleOnce(1.0E-10 + Math.ulp(1.0E-10), "1.0000000000000002E-10");
        this.testAppendDoubleOnce(1.0E-11 + Math.ulp(1.0E-11), "1.0000000000000001E-11");
        double d = -1.0E30;
        this.testAppendDoubleOnce(d - Math.ulp(d), "-1000000000000000158000000000000");
        d = -1.0E31;
        this.testAppendDoubleOnce(d - Math.ulp(d), "-1.0000000000000001E31");
        d = -1.0E32;
        this.testAppendDoubleOnce(d - Math.ulp(d), "-1.0000000000000002E32");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAppendDoubleOnce(double value, String expectedValue) {
        long address = UnsafeMemory.UNSAFE.allocateMemory(40L);
        try {
            String memVal = this.appendDoubleToString(value, address);
            Assert.assertEquals((String)("value; " + value), (Object)expectedValue, (Object)memVal);
        }
        finally {
            UnsafeMemory.UNSAFE.freeMemory(address);
        }
    }

    @Test
    public void testRandom() {
        int runLength = 1000000;
        IntStream.range(0, runLength).parallel().forEach(t -> {
            double d;
            Random r = new Random();
            long address = UnsafeMemory.UNSAFE.allocateMemory(40L);
            long l = r.nextLong() | 1L;
            for (int i = 0; i < 1000 && Double.isFinite(d = Double.longBitsToDouble(l += 2L)) && !(Math.abs(d) < 1.0E-20) && !(Math.abs(d) > 5.0E11); ++i) {
                String s = this.appendDoubleToString(d, address);
                double d2 = Double.parseDouble(s);
                if (d == d2) continue;
                String message = "" + (d - d2);
                Assert.assertEquals((String)message, (double)d, (double)d2, (double)0.0);
            }
            UnsafeMemory.UNSAFE.freeMemory(address);
        });
    }

    @Test
    public void testSequential() {
        IntStream.range(0, 10000).parallel().forEach(t -> {
            long address = UnsafeMemory.UNSAFE.allocateMemory(40L);
            double n = 1.0E15;
            for (int i = 1; i < 10000; i += 2) {
                long l = ((long)t * 10000L + (long)i) * 10191L + (long)n;
                double d = (double)l / n;
                String s = this.appendDoubleToString(d, address);
                double d2 = Double.parseDouble(s);
                if (d == d2) continue;
                Assert.assertEquals((String)("" + (d - d2)), (double)d, (double)d2, (double)0.0);
            }
            UnsafeMemory.UNSAFE.freeMemory(address);
        });
    }

    public String appendDoubleToString(double value, long address) {
        long end;
        UnsafeMemory.UNSAFE.putLong(address + 32L, 0L);
        long endAddress = UnsafeText.appendDouble((long)address, (double)value);
        if (endAddress > address + 32L) {
            Assert.fail((String)("value: " + value + " length: " + (endAddress - address)));
        }
        if ((end = UnsafeMemory.UNSAFE.getLong(address + 32L)) != 0L) {
            Assert.fail((String)("Overwrite: " + Long.toHexString(end)));
        }
        return LongStream.range(address, endAddress).mapToInt(addr -> UnsafeMemory.UNSAFE.getByte(null, addr)).mapToObj(c -> Character.valueOf((char)c)).reduce(new StringBuilder(), StringBuilder::append, StringBuilder::append).toString();
    }
}

