/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.io;

import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.InvalidMarshallableException;
import net.openhft.chronicle.core.io.Validatable;
import net.openhft.chronicle.core.io.ValidatableUtil;
import org.junit.Assert;
import org.junit.Test;

public class ValidatableTest {
    @Test
    public void validate() {
        DTOWithValidateToString d = new DTOWithValidateToString();
        try {
            d.toString();
            Assert.fail();
            throw new InvalidMarshallableException(null);
        }
        catch (InvalidMarshallableException invalidMarshallableException) {
            d.b = 1L;
            try {
                d.toString();
                Assert.fail();
                throw new InvalidMarshallableException(null);
            }
            catch (InvalidMarshallableException invalidMarshallableException2) {
                d.a = "hi";
                d.b = 1L;
                Assert.assertEquals((Object)"DTOWithValidateToString{a='hi', b=1}", (Object)d.toString());
                d.b = 0L;
                try {
                    d.toString();
                    Assert.fail();
                    throw new InvalidMarshallableException(null);
                }
                catch (InvalidMarshallableException invalidMarshallableException3) {
                    return;
                }
            }
        }
    }

    @Test
    public void validateDisabled() {
        ValidatableUtil.startValidateDisabled();
        DTOWithValidateToString d = new DTOWithValidateToString();
        try {
            Assert.assertEquals((Object)"DTOWithValidateToString{a='null', b=0}", (Object)d.toString());
            d.b = 1L;
            Assert.assertEquals((Object)"DTOWithValidateToString{a='null', b=1}", (Object)d.toString());
            d.a = "hi";
            d.b = 1L;
            Assert.assertEquals((Object)"DTOWithValidateToString{a='hi', b=1}", (Object)d.toString());
            ValidatableUtil.startValidateDisabled();
            try {
                d.b = 0L;
                Assert.assertEquals((Object)"DTOWithValidateToString{a='hi', b=0}", (Object)d.toString());
            }
            finally {
                ValidatableUtil.endValidateDisabled();
            }
        }
        finally {
            ValidatableUtil.endValidateDisabled();
        }
        try {
            d.toString();
            Assert.fail();
            throw new InvalidMarshallableException(null);
        }
        catch (InvalidMarshallableException invalidMarshallableException) {
            boolean failed = false;
            try {
                ValidatableUtil.endValidateDisabled();
                failed = true;
            }
            catch (AssertionError assertionError) {
                // empty catch block
            }
            Assert.assertFalse((boolean)failed);
            return;
        }
    }

    static class DTOWithValidateToString
    implements Validatable {
        String a;
        long b;

        DTOWithValidateToString() {
        }

        public void validate() throws InvalidMarshallableException {
            if (this.a == null) {
                throw new InvalidMarshallableException("a must not be null");
            }
            if (this.b <= 0L) {
                throw new InvalidMarshallableException("b must be positive");
            }
        }

        public String toString() {
            try {
                ValidatableUtil.validate((Object)this);
            }
            catch (InvalidMarshallableException e) {
                throw Jvm.rethrow((Throwable)e);
            }
            return "DTOWithValidateToString{a='" + this.a + '\'' + ", b=" + this.b + '}';
        }
    }
}

