/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.time;

import net.openhft.chronicle.core.time.LongTime;
import net.openhft.chronicle.core.time.SetTimeProvider;
import net.openhft.chronicle.core.time.SystemTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.core.time.UniqueMicroTimeProvider;
import org.junit.Assert;
import org.junit.Test;

public class UniqueMicroTimeProviderTest {
    @Test
    public void currentTimeMicros() throws IllegalStateException {
        UniqueMicroTimeProvider tp = new UniqueMicroTimeProvider();
        SetTimeProvider stp = new SetTimeProvider(SystemTimeProvider.INSTANCE.currentTimeNanos());
        tp.provider((TimeProvider)stp);
        long last = 0L;
        for (int i = 0; i < 4000; ++i) {
            stp.advanceNanos((long)i);
            long time = tp.currentTimeMicros();
            Assert.assertEquals((long)LongTime.toMicros((long)time), (long)time);
            Assert.assertTrue((time > last ? 1 : 0) != 0);
            last = time;
        }
    }

    @Test
    public void currentTimeNanos() throws IllegalStateException {
        UniqueMicroTimeProvider tp = new UniqueMicroTimeProvider();
        SetTimeProvider stp = new SetTimeProvider(SystemTimeProvider.INSTANCE.currentTimeNanos());
        tp.provider((TimeProvider)stp);
        long last = 0L;
        for (int i = 0; i < 4000; ++i) {
            stp.advanceNanos((long)i);
            long time = tp.currentTimeNanos();
            Assert.assertEquals((long)LongTime.toNanos((long)time), (long)time);
            Assert.assertTrue((time / 1000L > last ? 1 : 0) != 0);
            last = time / 1000L;
        }
    }
}

