/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Function;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.posix.PosixAPI;
import org.jetbrains.annotations.NotNull;

final class Bootstrap {
    public static final String OS_NAME = System.getProperty("os.name", "?");
    public static final String OS_ARCH = System.getProperty("os.arch", "?");
    public static final String VM_VENDOR = System.getProperty("java.vm.vendor", "?");
    public static final String VM_VERSION = System.getProperty("java.vm.version", "?");
    public static final String VM_NAME = System.getProperty("java.vm.name", "?");
    static final int JVM_JAVA_MAJOR_VERSION;
    static final boolean IS_JAVA_9_PLUS;
    static final boolean IS_JAVA_12_PLUS;
    static final boolean IS_JAVA_14_PLUS;
    static final boolean IS_JAVA_15_PLUS;
    static final boolean IS_JAVA_19_PLUS;

    private Bootstrap() {
    }

    static boolean isArm0() {
        return Boolean.parseBoolean(System.getProperty("jvm.isarm")) || OS_ARCH.startsWith("arm") || OS_ARCH.startsWith("aarch") || Bootstrap.isMacArm0();
    }

    static boolean isMacArm0() {
        return OS_NAME.equals("Mac OS X") && !OS_ARCH.equals("x86_64");
    }

    static boolean isAzulZing0() {
        return VM_VENDOR.startsWith("Azul ") && VM_VERSION.contains("zing");
    }

    static boolean isAzulZulu0() {
        return VM_VENDOR.startsWith("Azul ") && (VM_NAME.startsWith("OpenJDK ") || VM_NAME.startsWith("Zulu"));
    }

    private static int getMajorVersion0() {
        try {
            Method method = Runtime.class.getDeclaredMethod("version", new Class[0]);
            if (method != null) {
                Object version = method.invoke((Object)Runtime.getRuntime(), new Object[0]);
                Class<?> clz = Class.forName("java.lang.Runtime$Version");
                return (Integer)clz.getDeclaredMethod("major", new Class[0]).invoke(version, new Object[0]);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException method) {
            // empty catch block
        }
        try {
            return Integer.parseInt(Runtime.class.getPackage().getSpecificationVersion().split("\\.")[1]);
        }
        catch (NumberFormatException nfe) {
            Jvm.warn().on(Jvm.class, "Unable to get the major version, defaulting to 8 " + nfe);
            return 8;
        }
    }

    static {
        PosixAPI.posix();
        try {
            Class.forName("net.openhft.affinity.Affinity");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        JVM_JAVA_MAJOR_VERSION = Bootstrap.getMajorVersion0();
        IS_JAVA_9_PLUS = JVM_JAVA_MAJOR_VERSION > 8;
        IS_JAVA_12_PLUS = JVM_JAVA_MAJOR_VERSION > 11;
        IS_JAVA_14_PLUS = JVM_JAVA_MAJOR_VERSION > 13;
        IS_JAVA_15_PLUS = JVM_JAVA_MAJOR_VERSION > 14;
        IS_JAVA_19_PLUS = JVM_JAVA_MAJOR_VERSION > 18;
    }

    static final class CpuClass {
        static final String CPU_MODEL;
        private static final String PROCESS = "process ";

        private CpuClass() {
        }

        @NotNull
        static Function<String, String> removingTag() {
            return line -> line.replaceFirst("[^:]*+: ", "");
        }

        static {
            String model;
            block34: {
                model = Jvm.getProperty("os.arch", "unknown");
                try {
                    Path path = Paths.get("/proc/cpuinfo", new String[0]);
                    if (Files.isReadable(path)) {
                        model = Files.lines(path).filter(line -> line.startsWith("model name")).map(CpuClass.removingTag()).findFirst().orElse(model);
                        break block34;
                    }
                    if (OS.isWindows()) {
                        String cmd = "wmic cpu get name";
                        Process process = new ProcessBuilder(cmd.split(" ")).redirectErrorStream(true).start();
                        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                            model = reader.lines().map(String::trim).filter(s -> !"Name".equals(s) && !s.isEmpty()).findFirst().orElse(model);
                        }
                        try {
                            int ret = process.waitFor();
                            if (ret != 0) {
                                Jvm.warn().on(CpuClass.class, PROCESS + cmd + " returned " + ret);
                            }
                        }
                        catch (InterruptedException e) {
                            Jvm.warn().on(CpuClass.class, PROCESS + cmd + " waitFor threw ", e);
                            Thread.currentThread().interrupt();
                        }
                        process.destroy();
                        break block34;
                    }
                    if (!OS.isMacOSX()) break block34;
                    String cmd = "sysctl -a";
                    Process process = new ProcessBuilder(cmd.split(" ")).redirectErrorStream(true).start();
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                        model = reader.lines().map(String::trim).filter(s -> s.startsWith("machdep.cpu.brand_string")).map(CpuClass.removingTag()).findFirst().orElse(model);
                    }
                    try {
                        int ret = process.waitFor();
                        if (ret != 0) {
                            Jvm.warn().on(CpuClass.class, PROCESS + cmd + " returned " + ret);
                        }
                    }
                    catch (InterruptedException e) {
                        Jvm.warn().on(CpuClass.class, PROCESS + cmd + " waitFor threw ", e);
                        Thread.currentThread().interrupt();
                    }
                    process.destroy();
                }
                catch (IOException e) {
                    Jvm.debug().on(CpuClass.class, "Unable to read cpuinfo", e);
                }
            }
            CPU_MODEL = model;
        }
    }
}

