/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

import net.openhft.chronicle.core.ChronicleInitRunnable;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.testframework.process.JavaProcessBuilder;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class ChronicleInitTest {
    public static void main(String[] args) {
        Assertions.assertEquals((Object)"dolor", (Object)Jvm.getProperty((String)"lorem.ipsum"));
        Assertions.assertFalse((boolean)Jvm.isResourceTracing());
        Assertions.assertTrue((boolean)Jvm.areOptionalSafepointsEnabled());
        Assertions.assertEquals((Object)"false", (Object)Jvm.getProperty((String)"jvm.safepoint.enabled"));
    }

    @Test
    public void testPositive() throws Exception {
        Process process = JavaProcessBuilder.create(ChronicleInitTest.class).withJvmArguments(new String[]{"-Dchronicle.init.runnable=" + ResourceTracingInit.class.getName()}).start();
        try {
            Assertions.assertEquals((int)0, (int)process.waitFor());
        }
        finally {
            JavaProcessBuilder.printProcessOutput((String)"ChronicleInitTest", (Process)process);
        }
    }

    @Test
    public void testPostInitNegative() throws Exception {
        Process process = JavaProcessBuilder.create(ChronicleInitTest.class).withJvmArguments(new String[]{"-Dchronicle.postinit.runnable=" + ResourceTracingInit.class.getName()}).start();
        try {
            Assertions.assertEquals((int)1, (int)process.waitFor());
        }
        finally {
            JavaProcessBuilder.printProcessOutput((String)"ChronicleInitTest", (Process)process);
        }
    }

    @Test
    public void testNoInit() throws Exception {
        Process process = JavaProcessBuilder.create(ChronicleInitTest.class).start();
        try {
            Assertions.assertNotEquals((int)0, (int)process.waitFor());
        }
        finally {
            JavaProcessBuilder.printProcessOutput((String)"ChronicleInitTest", (Process)process);
        }
    }

    @Test
    public void testBadClass() throws Exception {
        Process process = JavaProcessBuilder.create(ChronicleInitTest.class).withJvmArguments(new String[]{"-Dchronicle.init.class=" + ChronicleInitTest.class.getName()}).start();
        try {
            Assertions.assertNotEquals((int)0, (int)process.waitFor());
        }
        finally {
            JavaProcessBuilder.printProcessOutput((String)"ChronicleInitTest", (Process)process);
        }
    }

    public static class ServiceLoaderInit
    implements ChronicleInitRunnable {
        public void run() {
            System.setProperty("lorem.ipsum", "dolor");
        }

        public void postInit() {
            System.setProperty("jvm.safepoint.enabled", "false");
        }
    }

    public static class ResourceTracingInit
    implements Runnable {
        @Override
        public void run() {
            System.err.println("disabling resource tracking");
            System.setProperty("jvm.resource.tracing", "false");
        }
    }
}

