/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

import java.util.Map;
import javax.naming.TimeLimitExceededException;
import junit.framework.TestCase;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.LicenceCheck;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class LicenceCheckTest {
    @After
    public void tearDown() {
        System.getProperties().remove("chronicle.license");
        Jvm.resetExceptionHandlers();
    }

    @Test(expected=TimeLimitExceededException.class)
    public void checkExpiredExpiryFile() {
        LicenceCheck.check((String)"test", LicenceCheck.class);
        Assert.fail((String)"should have got an AssertionError");
    }

    @Test
    public void checkUnexpiredExpiryFileWithNewline() {
        LicenceCheck.check((String)"test2", LicenceCheck.class);
    }

    @Test(expected=TimeLimitExceededException.class)
    public void checkEvalExpired() {
        LicenceCheck.check((String)"test", TestCase.class);
    }

    @Test
    public void checkLicense() {
        System.setProperty("chronicle.license", "product=test.,owner=Test Unit,expires=9999-01-01,code=123456789");
        Map map = Jvm.recordExceptions();
        LicenceCheck.check((String)"test", null);
        Assert.assertTrue((boolean)map.toString().contains("license for Test Unit expires in about 7"));
    }

    @Test(expected=TimeLimitExceededException.class)
    public void checkLicenseExpired() {
        System.setProperty("chronicle.license", "product=test.,owner=Test Unit,expires=2019-01-01,code=123456789");
        LicenceCheck.check((String)"test", null);
    }
}

