/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

import java.util.List;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.IntPredicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.testframework.Product;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.TestFactory;
import org.junit.jupiter.params.provider.Arguments;

interface UnsafeMemoryTestMixin<T> {
    public static final int CACHE_LINE_SIZE = 64;
    public static final int CACHE_LINE_SIZE_ARM = 32;
    public static final int MEM_SIZE = 128;
    public static final int NO_THREADS = 5;
    public static final float EPSILON = 1.0E-7f;

    public Class<T> type();

    public IntPredicate alignedToType();

    public T zero();

    public T nonZero();

    public Stream<T> sequence();

    public List<NamedOperation<MemoryLongObjConsumer<T>>> addressWriteOperations();

    public List<NamedOperation<MemoryLongFunction<T>>> addressReadOperations();

    public List<NamedOperation<MemoryObjLongObjConsumer<T>>> objectWriteOperations();

    public List<NamedOperation<MemoryObjLongFunction<T>>> objectReadOperations();

    public MemoryLongObjConsumer<T> addressWriteVolatileOperation();

    public MemoryLongFunction<T> addressReadVolatileOperation();

    public MemoryObjLongObjConsumer<T> objectWriteVolatileOperation();

    public MemoryObjLongFunction<T> objectReadVolatileOperation();

    @TestFactory
    default public Stream<DynamicTest> readWriteTests() {
        return UnsafeMemoryTestMixin.arguments().flatMap(args -> {
            if (UnsafeMemoryTestMixin.mode(args).isDirectAddressing()) {
                return Product.of(this.addressWriteOperations(), this.addressReadOperations()).map(p -> {
                    Variant variant = new Variant((Arguments)args);
                    String operationName = ((NamedOperation)p.first()).name() + " and " + ((NamedOperation)p.second()).name();
                    return DynamicTest.dynamicTest((String)(variant.name() + " using " + operationName), () -> {
                        this.test(variant, this.nonZero(), (MemoryLongObjConsumer)((NamedOperation)p.first()).operation(), (MemoryLongFunction)((NamedOperation)p.second()).operation());
                        variant.close();
                    });
                });
            }
            return Product.of(this.objectWriteOperations(), this.objectReadOperations()).map(p -> {
                Variant variant = new Variant((Arguments)args);
                String operationName = ((NamedOperation)p.first()).name() + " and " + ((NamedOperation)p.second()).name();
                return DynamicTest.dynamicTest((String)(variant.name() + " using " + operationName), () -> {
                    this.testObj(variant, this.nonZero(), (MemoryObjLongObjConsumer)((NamedOperation)p.first()).operation(), (MemoryObjLongFunction)((NamedOperation)p.second()).operation());
                    variant.close();
                });
            });
        });
    }

    @TestFactory
    default public Stream<DynamicTest> volatileTests() {
        return UnsafeMemoryTestMixin.arguments().flatMap(args -> this.interestingOffsets().mapToObj(offset -> {
            Variant variant = new Variant((Arguments)args);
            return DynamicTest.dynamicTest((String)(variant.name() + " " + this.type().getSimpleName() + "@" + offset), () -> {
                CopyOnWriteArrayList threadErrors = new CopyOnWriteArrayList();
                CyclicBarrier barrier = new CyclicBarrier(6);
                Supplier<Object> getter = variant.mode().isDirectAddressing() ? () -> this.addressReadVolatileOperation().apply(variant.memory(), variant.addr() + (long)offset) : () -> this.objectReadVolatileOperation().apply(variant.memory(), variant.object(), variant.addr() + (long)offset);
                Consumer<Object> setter = variant.mode().isDirectAddressing() ? b -> this.addressWriteVolatileOperation().accept(variant.memory(), variant.addr() + (long)offset, b) : b -> this.objectWriteVolatileOperation().accept(variant.memory(), variant.object(), variant.addr() + (long)offset, b);
                List<Thread> threads = IntStream.range(0, 5).mapToObj(i -> new Thread(new Reader(i, barrier, getter, this, threadErrors), "Reader " + i + "@" + offset)).collect(Collectors.toList());
                threads.forEach(Thread::start);
                setter.accept(this.zero());
                UnsafeMemoryTestMixin.await(barrier);
                barrier.reset();
                this.sequence().forEach(v -> {
                    setter.accept(v);
                    long expireNs = System.nanoTime() + TimeUnit.MICROSECONDS.toNanos(100L);
                    while (System.nanoTime() < expireNs) {
                    }
                    try {
                        barrier.await(1L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException | BrokenBarrierException | TimeoutException e) {
                        Assertions.fail((String)threadErrors.toString());
                    }
                    barrier.reset();
                });
                if (!threadErrors.isEmpty()) {
                    Assertions.fail((String)((Object)threadErrors).toString());
                }
                for (Thread t : threads) {
                    t.join();
                }
                variant.close();
            });
        }));
    }

    public static int await(CyclicBarrier cyclicBarrier) {
        try {
            return cyclicBarrier.await();
        }
        catch (InterruptedException | BrokenBarrierException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static int await(CyclicBarrier cyclicBarrier, long timeOut, TimeUnit timeUnit) {
        try {
            return cyclicBarrier.await(timeOut, timeUnit);
        }
        catch (InterruptedException | BrokenBarrierException | TimeoutException e) {
            throw new AssertionError((Object)e);
        }
    }

    default public void test(Variant variant, T testValue, MemoryLongObjConsumer<T> addressWriter, MemoryLongFunction<T> addressReader) {
        for (int i = 0; i <= 64; ++i) {
            addressWriter.accept(variant.memory(), variant.addr() + (long)i, testValue);
            T t = addressReader.apply(variant.memory(), variant.addr() + (long)i);
            Assertions.assertEquals(testValue, t);
        }
    }

    default public <T> void testObj(Variant variant, T testValue, MemoryObjLongObjConsumer<T> objectWriter, MemoryObjLongFunction<T> objectReader) {
        for (int i = 0; i <= 64; ++i) {
            objectWriter.accept(variant.memory(), variant.object(), variant.addr() + (long)i, testValue);
            T t = objectReader.apply(variant.memory(), variant.object(), variant.addr() + (long)i);
            Assertions.assertEquals(testValue, t);
        }
    }

    default public IntStream interestingOffsets() {
        return IntStream.concat(IntStream.of(0, 1), IntStream.of(32, 64).flatMap(s -> IntStream.rangeClosed(s - 8, s))).filter(this.alignedToType());
    }

    public static Stream<Arguments> arguments() {
        UnsafeMemory memory1 = new UnsafeMemory();
        UnsafeMemory.ARMMemory memory2 = new UnsafeMemory.ARMMemory();
        Stream.Builder<Arguments> builder = Stream.builder();
        if (!Jvm.isArm()) {
            builder.add(Arguments.of((Object[])new Object[]{"UnsafeMemory offheap", memory1, Mode.NATIVE_ADDRESS}));
            builder.add(Arguments.of((Object[])new Object[]{"UnsafeMemory onheap", memory1, Mode.OBJECT}));
            builder.add(Arguments.of((Object[])new Object[]{"UnsafeMemory offheap (null)", memory1, Mode.NULL_OBJECT}));
        }
        builder.add(Arguments.of((Object[])new Object[]{"ARMMemory offheap", memory2, Mode.NATIVE_ADDRESS}));
        builder.add(Arguments.of((Object[])new Object[]{"ARMMemory onheap", memory2, Mode.OBJECT}));
        builder.add(Arguments.of((Object[])new Object[]{"ARMMemory offheap (null)", memory2, Mode.NULL_OBJECT}));
        return builder.build();
    }

    public static Mode mode(Arguments args) {
        return (Mode)((Object)args.get()[2]);
    }

    public static enum Mode {
        NATIVE_ADDRESS,
        OBJECT,
        NULL_OBJECT;


        public boolean isDirectAddressing() {
            return this == NATIVE_ADDRESS;
        }
    }

    public static final class Variant
    implements AutoCloseable {
        private final Runnable closer;
        private final String name;
        private final UnsafeMemory memory;
        private final Mode mode;
        private final Object object;
        private final long addr;

        public Variant(Arguments args) {
            this.name = (String)args.get()[0];
            this.memory = (UnsafeMemory)args.get()[1];
            this.mode = (Mode)((Object)args.get()[2]);
            switch (this.mode) {
                case NATIVE_ADDRESS: 
                case NULL_OBJECT: {
                    this.object = null;
                    this.addr = UnsafeMemory.UNSAFE.allocateMemory(128L);
                    this.closer = () -> UnsafeMemory.UNSAFE.freeMemory(this.addr);
                    break;
                }
                case OBJECT: {
                    this.object = new byte[128];
                    this.addr = UnsafeMemory.MEMORY.arrayBaseOffset(byte[].class);
                    this.closer = () -> {};
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal mode: " + (Object)((Object)this.mode));
                }
            }
        }

        public String name() {
            return this.name;
        }

        public UnsafeMemory memory() {
            return this.memory;
        }

        public Mode mode() {
            return this.mode;
        }

        public Object object() {
            return this.object;
        }

        public long addr() {
            return this.addr;
        }

        @Override
        public void close() {
            this.closer.run();
        }
    }

    @FunctionalInterface
    public static interface MemoryObjLongFunction<T> {
        public T apply(UnsafeMemory var1, Object var2, long var3);
    }

    @FunctionalInterface
    public static interface MemoryObjLongObjConsumer<T> {
        public void accept(UnsafeMemory var1, Object var2, long var3, T var5);
    }

    @FunctionalInterface
    public static interface MemoryLongFunction<T> {
        public T apply(UnsafeMemory var1, long var2);
    }

    @FunctionalInterface
    public static interface MemoryLongObjConsumer<T> {
        public void accept(UnsafeMemory var1, long var2, T var4);
    }

    public static final class NamedOperation<T> {
        private final String name;
        private final T operation;

        NamedOperation(String name, T operation) {
            this.name = name;
            this.operation = operation;
        }

        String name() {
            return this.name;
        }

        T operation() {
            return this.operation;
        }
    }

    public static final class Reader<T>
    implements Runnable {
        private final int no;
        private final CyclicBarrier barrier;
        private final Supplier<T> getter;
        private final UnsafeMemoryTestMixin<T> mixin;
        private final List<String> errors;

        public Reader(int no, CyclicBarrier barrier, Supplier<T> getter, UnsafeMemoryTestMixin<T> mixin, List<String> errors) {
            this.no = no;
            this.barrier = barrier;
            this.getter = getter;
            this.mixin = mixin;
            this.errors = errors;
        }

        @Override
        public void run() {
            List sequence = this.mixin.sequence().collect(Collectors.toList());
            UnsafeMemoryTestMixin.await(this.barrier);
            T previousValue = this.mixin.zero();
            for (Object expected : sequence) {
                T actual;
                while ((actual = this.getter.get()).equals(previousValue)) {
                }
                if (!expected.equals(actual)) {
                    this.errors.add("Reader " + this.no + " expected " + expected + " but was " + actual);
                    break;
                }
                previousValue = actual;
                UnsafeMemoryTestMixin.await(this.barrier, 1000L, TimeUnit.MILLISECONDS);
            }
        }
    }
}

