/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.cleaner.impl;

import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.util.ObjectUtils;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;

public final class CleanerTestUtil {
    private CleanerTestUtil() {
    }

    public static void test(Consumer<ByteBuffer> cleaner) {
        ObjectUtils.requireNonNull(cleaner);
        try {
            AtomicLong reservedMemory;
            if (Jvm.majorVersion() < 16) {
                Field field;
                Class<?> bitsClass = Class.forName("java.nio.Bits");
                try {
                    field = bitsClass.getDeclaredField("RESERVED_MEMORY");
                }
                catch (NoSuchFieldException nfe) {
                    field = bitsClass.getDeclaredField("reservedMemory");
                }
                field.setAccessible(true);
                reservedMemory = (AtomicLong)field.get(null);
            } else {
                reservedMemory = new AtomicLong();
            }
            long allocatedBefore = reservedMemory.get();
            ByteBuffer bb = ByteBuffer.allocateDirect(64);
            cleaner.accept(bb);
            long allocatedAfter = reservedMemory.get();
            Assert.assertTrue((allocatedBefore <= allocatedAfter ? 1 : 0) != 0);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
            Assertions.fail((Throwable)e);
        }
    }
}

