/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.io;

import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.AbstractCloseableReferenceCounted;
import net.openhft.chronicle.core.io.ReferenceCountedTracerContractTest;
import net.openhft.chronicle.core.io.ReferenceOwner;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class AbstractCloseableReferenceCountedTest
extends ReferenceCountedTracerContractTest {
    @Test
    public void reserve() throws IllegalStateException, IllegalArgumentException {
        Assume.assumeTrue((boolean)Jvm.isResourceTracing());
        MyCloseableReferenceCounted rc = this.createReferenceCounted();
        Assert.assertEquals((long)1L, (long)rc.refCount());
        ReferenceOwner a = ReferenceOwner.temporary((String)"a");
        rc.reserve(a);
        Assert.assertEquals((long)2L, (long)rc.refCount());
        ReferenceOwner b = ReferenceOwner.temporary((String)"b");
        rc.reserve(b);
        Assert.assertEquals((long)3L, (long)rc.refCount());
        try {
            rc.reserve(a);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertEquals((long)3L, (long)rc.refCount());
        rc.release(b);
        Assert.assertEquals((long)2L, (long)rc.refCount());
        rc.release(a);
        Assert.assertEquals((long)1L, (long)rc.refCount());
        Assert.assertEquals((long)0L, (long)rc.performRelease);
        rc.releaseLast();
        Assert.assertEquals((long)0L, (long)rc.refCount());
        Assert.assertEquals((long)1L, (long)rc.performRelease);
    }

    @Test
    public void reserveWhenClosed() throws IllegalStateException, IllegalArgumentException {
        MyCloseableReferenceCounted rc = this.createReferenceCounted();
        Assert.assertEquals((long)1L, (long)rc.refCount());
        ReferenceOwner a = ReferenceOwner.temporary((String)"a");
        rc.reserve(a);
        Assert.assertEquals((long)2L, (long)rc.refCount());
        rc.close();
        Assert.assertEquals((long)1L, (long)rc.refCount());
        ReferenceOwner b = ReferenceOwner.temporary((String)"b");
        try {
            rc.reserve(b);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)rc.refCount());
        Assert.assertFalse((boolean)rc.tryReserve(b));
        Assert.assertEquals((long)1L, (long)rc.refCount());
        rc.release(a);
        Assert.assertEquals((long)0L, (long)rc.refCount());
        Assert.assertEquals((long)1L, (long)rc.performRelease);
        try {
            rc.throwExceptionIfReleased();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    protected MyCloseableReferenceCounted createReferenceCounted() {
        return new MyCloseableReferenceCounted();
    }

    static class MyCloseableReferenceCounted
    extends AbstractCloseableReferenceCounted {
        int performRelease;

        protected void performRelease() {
            ++this.performRelease;
        }
    }
}

