/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.util;

import java.util.Arrays;
import java.util.Collection;
import net.openhft.chronicle.core.util.CoreDynamicEnum;
import net.openhft.chronicle.core.util.ObjectUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ObjectUtilsConvertToTest {
    private final Object converted;
    private final String input;

    public ObjectUtilsConvertToTest(Object converted, String input) {
        this.converted = converted;
        this.input = input;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({Boolean.TRUE, "Y"}, {Boolean.TRUE, "yes"}, {Boolean.FALSE, "N"}, {Boolean.FALSE, "no"}, {1.0, "1.0"}, {1, "1"}, {1L, "1"}, {DEnum.ZERO, "Zero"}, {DEnum.ONE, "One"}, {DEnum.TWO, "Two"});
    }

    @Test
    public void convertTo() throws IllegalStateException, IllegalArgumentException {
        Assert.assertEquals((Object)this.converted, (Object)ObjectUtils.convertTo(this.converted.getClass(), (Object)this.input));
    }

    static class DEnum
    implements CoreDynamicEnum<DEnum> {
        static final DEnum ZERO = new DEnum("Zero", 0);
        static final DEnum ONE = new DEnum("One", 1);
        static final DEnum TWO = new DEnum("Two", 2);
        private final String name;
        private final int ordinal;

        public DEnum(String name, int ordinal) {
            this.name = name;
            this.ordinal = ordinal;
        }

        public String name() {
            return this.name;
        }

        public int ordinal() {
            return 0;
        }
    }
}

