/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.util;

import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import net.openhft.chronicle.core.onoes.ExceptionHandler;
import net.openhft.chronicle.core.util.ObjectUtils;
import org.junit.Assert;
import org.junit.Test;

public class ObjectUtilsTest {
    @Test
    public void testImmutable() {
        for (Class c : new Class[]{String.class, Integer.class, Date.class, BigDecimal.class, ZonedDateTime.class}) {
            Assert.assertEquals((String)c.getName(), (Object)ObjectUtils.Immutability.MAYBE, (Object)ObjectUtils.isImmutable((Class)c));
        }
        for (Class c : new Class[]{ArrayList.class, HashMap.class}) {
            Assert.assertEquals((String)c.getName(), (Object)ObjectUtils.Immutability.NO, (Object)ObjectUtils.isImmutable((Class)c));
        }
    }

    @Test
    public void testConvert() throws IllegalStateException, IllegalArgumentException {
        Assert.assertEquals((long)49L, (long)((Character)ObjectUtils.convertTo(Character.TYPE, (Object)1)).charValue());
        Assert.assertEquals((long)49L, (long)((Character)ObjectUtils.convertTo(Character.TYPE, (Object)1L)).charValue());
        Assert.assertEquals((long)1L, (long)((Integer)ObjectUtils.convertTo(Integer.TYPE, (Object)Character.valueOf('1'))).intValue());
        Assert.assertEquals((long)1L, (long)((Long)ObjectUtils.convertTo(Long.TYPE, (Object)Character.valueOf('1'))));
        Assert.assertEquals((double)1.0, (double)((Double)ObjectUtils.convertTo(Double.TYPE, (Object)Character.valueOf('1'))), (double)0.0);
    }

    @Test
    public void testNoDefaultClassForInterfaceNewInstanceThrows() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            ExceptionHandler cfr_ignored_0 = (ExceptionHandler)ObjectUtils.newInstance(ExceptionHandler.class);
        });
    }
}

