/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.util;

import java.nio.charset.StandardCharsets;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.util.StringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class StringUtilsTest {
    @Test
    public void testFirstLowerCase() {
        Assert.assertEquals((Object)"", (Object)StringUtils.firstLowerCase((String)""));
        Assert.assertEquals((Object)"99", (Object)StringUtils.firstLowerCase((String)"99"));
        Assert.assertEquals((Object)"a", (Object)StringUtils.firstLowerCase((String)"A"));
        Assert.assertEquals((Object)"a", (Object)StringUtils.firstLowerCase((String)"a"));
        Assert.assertEquals((Object)"aA", (Object)StringUtils.firstLowerCase((String)"AA"));
        Assert.assertEquals((Object)"aa", (Object)StringUtils.firstLowerCase((String)"Aa"));
    }

    @Test
    public void testToTitleCase() {
        Assert.assertEquals((Object)"", (Object)StringUtils.toTitleCase((String)""));
        Assert.assertEquals((Object)"99", (Object)StringUtils.toTitleCase((String)"99"));
        Assert.assertEquals((Object)"A", (Object)StringUtils.toTitleCase((String)"A"));
        Assert.assertEquals((Object)"A", (Object)StringUtils.toTitleCase((String)"a"));
        Assert.assertEquals((Object)"AA", (Object)StringUtils.toTitleCase((String)"AA"));
        Assert.assertEquals((Object)"AA", (Object)StringUtils.toTitleCase((String)"Aa"));
        Assert.assertEquals((Object)"AAA", (Object)StringUtils.toTitleCase((String)"AAA"));
        Assert.assertEquals((Object)"AA_A", (Object)StringUtils.toTitleCase((String)"AaA"));
        Assert.assertEquals((Object)"A_AA", (Object)StringUtils.toTitleCase((String)"AAa"));
        Assert.assertEquals((Object)"AAA", (Object)StringUtils.toTitleCase((String)"Aaa"));
        Assert.assertEquals((Object)"AAAA", (Object)StringUtils.toTitleCase((String)"AAAA"));
        Assert.assertEquals((Object)"AA_AA", (Object)StringUtils.toTitleCase((String)"AaAA"));
        Assert.assertEquals((Object)"A_AA_A", (Object)StringUtils.toTitleCase((String)"AAaA"));
        Assert.assertEquals((Object)"AAA_A", (Object)StringUtils.toTitleCase((String)"AaaA"));
        Assert.assertEquals((Object)"AA_AA", (Object)StringUtils.toTitleCase((String)"AAAa"));
        Assert.assertEquals((Object)"AA_AA", (Object)StringUtils.toTitleCase((String)"AaAa"));
        Assert.assertEquals((Object)"A_AAA", (Object)StringUtils.toTitleCase((String)"AAaa"));
        Assert.assertEquals((Object)"AAAA", (Object)StringUtils.toTitleCase((String)"Aaaa"));
    }

    @Test
    public void shouldGetCharsOfStringBuilder() {
        StringBuilder sb = new StringBuilder(11).append("foobar_nine");
        char[] chars = StringUtils.extractChars((StringBuilder)sb);
        Assert.assertEquals((Object)sb.toString(), (Object)new String(chars));
    }

    @Test
    public void shouldGetCharsOfString() {
        String s = "foobar_nine";
        char[] chars = StringUtils.extractChars((String)"foobar_nine");
        Assert.assertEquals((Object)"foobar_nine", (Object)new String(chars));
    }

    @Test
    public void shouldExtractBytesFromString() {
        Assume.assumeTrue((boolean)Jvm.isJava9Plus());
        MatcherAssert.assertThat((String)"Is this test running on JDK9 with compact strings disabled?", (Object)StringUtils.extractBytes((String)"foobar"), (Matcher)CoreMatchers.is((Object)"foobar".getBytes(StandardCharsets.US_ASCII)));
    }

    @Test
    public void shouldExtractBytesFromStringBuilder() {
        Assert.assertEquals((long)-2338138987911860342L, (long)Maths.hash64((StringBuilder)new StringBuilder("foobar")));
    }

    @Test
    public void shouldCreateNewStringFromChars() {
        char[] chars = new char[]{'A', 'B', 'C'};
        Assert.assertEquals((Object)new String(chars), (Object)StringUtils.newString((char[])chars));
    }

    @Test
    public void shouldCreateNewStringFromBytes() {
        Assume.assumeTrue((boolean)Jvm.isJava9Plus());
        byte[] bytes = new byte[]{65, 66, 67};
        Assert.assertEquals((Object)StringUtils.newStringFromBytes((byte[])bytes), (Object)new String(bytes));
    }

    @Test
    public void testParseDouble() {
        for (double d : new double[]{Double.NaN, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, -1.0, 1.0, 9999.0}) {
            Assert.assertEquals((double)d, (double)StringUtils.parseDouble((CharSequence)Double.toString(d)), (double)0.0);
        }
        Assert.assertEquals((double)1.0, (double)StringUtils.parseDouble((CharSequence)"1"), (double)0.0);
        Assert.assertEquals((double)0.0, (double)StringUtils.parseDouble((CharSequence)"-0"), (double)0.0);
        Assert.assertEquals((double)123.0, (double)StringUtils.parseDouble((CharSequence)"123"), (double)0.0);
        Assert.assertEquals((double)-1.0, (double)StringUtils.parseDouble((CharSequence)"-1"), (double)0.0);
    }

    @Test
    public void testIsEqual() {
        StringBuilder emptySb = new StringBuilder();
        Assert.assertTrue((boolean)StringUtils.isEqual((StringBuilder)emptySb, (CharSequence)emptySb));
        Assert.assertTrue((boolean)StringUtils.isEqual(null, null));
        Assert.assertFalse((boolean)StringUtils.isEqual((StringBuilder)emptySb, null));
        Assert.assertFalse((boolean)StringUtils.isEqual(null, (CharSequence)emptySb));
        Assert.assertFalse((boolean)StringUtils.isEqual((StringBuilder)new StringBuilder(), (CharSequence)"a"));
        Assert.assertFalse((boolean)StringUtils.isEqual((StringBuilder)new StringBuilder().append("a"), (CharSequence)"b"));
        Assert.assertFalse((boolean)StringUtils.isEqual((StringBuilder)new StringBuilder().append("test"), (CharSequence)"Test"));
        Assert.assertTrue((boolean)StringUtils.isEqual((StringBuilder)new StringBuilder().append("TheSame"), (CharSequence)"TheSame"));
        Assert.assertFalse((boolean)StringUtils.isEqual((StringBuilder)new StringBuilder().append("\u0394"), (CharSequence)"\u0393"));
        Assert.assertFalse((boolean)StringUtils.isEqual((StringBuilder)new StringBuilder().append("\u0394\u0394\u0394\u0394\u0394"), (CharSequence)"\u0394\u0394\u20ac\u0394\u0394"));
        Assert.assertTrue((boolean)StringUtils.isEqual((StringBuilder)new StringBuilder().append("\u0394\u0394\u0394\u0394\u0394"), (CharSequence)"\u0394\u0394\u0394\u0394\u0394"));
        Assert.assertTrue((boolean)StringUtils.isEqual((StringBuilder)new StringBuilder(), (CharSequence)""));
    }
}

