/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ServiceLoader;
import net.openhft.chronicle.core.ChronicleInit;
import net.openhft.chronicle.core.ChronicleInitRunnable;
import net.openhft.chronicle.core.CoreTestCommon;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.testframework.process.JavaProcessBuilder;
import org.junit.Test;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;

public class ChronicleInitTest
extends CoreTestCommon {
    private final ByteArrayOutputStream errContent = new ByteArrayOutputStream();
    private final PrintStream originalErr = System.err;

    @BeforeEach
    public void setUpStream() {
        System.setErr(new PrintStream(this.errContent));
    }

    @AfterEach
    public void restoreStream() {
        System.setErr(this.originalErr);
    }

    public static void main(String[] args) {
        Assertions.assertEquals((Object)"dolor", (Object)Jvm.getProperty((String)"lorem.ipsum"));
        Assertions.assertFalse((boolean)Jvm.isResourceTracing());
        Assertions.assertTrue((boolean)Jvm.areOptionalSafepointsEnabled());
        Assertions.assertEquals((Object)"false", (Object)Jvm.getProperty((String)"jvm.safepoint.enabled"));
    }

    @Test
    public void initShouldNotThrowException() {
        Assertions.assertDoesNotThrow(ChronicleInit::init, (String)"Calling init should not throw an exception");
    }

    @Test
    public void postInitShouldNotThrowException() {
        Assertions.assertDoesNotThrow(ChronicleInit::postInit, (String)"Calling postInit should not throw an exception");
    }

    @Test
    public void shouldLoadServiceProviders() {
        ServiceLoader<ChronicleInitRunnable> runnableLoader = ServiceLoader.load(ChronicleInitRunnable.class);
        Assertions.assertTrue((boolean)runnableLoader.iterator().hasNext(), (String)"Service providers should be loaded");
    }

    @Test
    public void testPositive() throws Exception {
        Process process = JavaProcessBuilder.create(ChronicleInitTest.class).withJvmArguments(new String[]{"-Dchronicle.init.runnable=" + ResourceTracingInit.class.getName()}).start();
        try {
            Assertions.assertEquals((int)0, (int)process.waitFor());
        }
        finally {
            JavaProcessBuilder.printProcessOutput((String)"ChronicleInitTest", (Process)process);
        }
    }

    @Test
    public void testPostInitNegative() throws Exception {
        Process process = JavaProcessBuilder.create(ChronicleInitTest.class).withJvmArguments(new String[]{"-Dchronicle.postinit.runnable=" + ResourceTracingInit.class.getName()}).start();
        try {
            Assertions.assertEquals((int)1, (int)process.waitFor());
        }
        finally {
            JavaProcessBuilder.printProcessOutput((String)"ChronicleInitTest", (Process)process);
        }
    }

    @Test
    public void testNoInit() throws Exception {
        Process process = JavaProcessBuilder.create(ChronicleInitTest.class).start();
        try {
            Assertions.assertNotEquals((int)0, (int)process.waitFor());
        }
        finally {
            JavaProcessBuilder.printProcessOutput((String)"ChronicleInitTest", (Process)process);
        }
    }

    @Test
    public void testBadClass() throws Exception {
        Process process = JavaProcessBuilder.create(ChronicleInitTest.class).withJvmArguments(new String[]{"-Dchronicle.init.class=" + ChronicleInitTest.class.getName()}).start();
        try {
            Assertions.assertNotEquals((int)0, (int)process.waitFor());
        }
        finally {
            JavaProcessBuilder.printProcessOutput((String)"ChronicleInitTest", (Process)process);
        }
    }

    public static class ServiceLoaderInit
    implements ChronicleInitRunnable {
        public void run() {
            System.setProperty("lorem.ipsum", "dolor");
        }

        public void postInit() {
            System.setProperty("jvm.safepoint.enabled", "false");
        }
    }

    public static class ResourceTracingInit
    implements Runnable {
        @Override
        public void run() {
            System.err.println("disabling resource tracking");
            System.setProperty("jvm.resource.tracing", "false");
        }
    }
}

