/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.internal;

import java.lang.ref.Reference;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.nio.channels.ServerSocketChannel;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.internal.CloseableUtils;
import net.openhft.chronicle.core.io.Closeable;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class CloseableUtilsTest {
    private Closeable mockCloseable;
    private Collection<Closeable> mockCloseables;
    private ServerSocketChannel mockServerSocketChannel;
    private AutoCloseable mockAutoCloseable;
    private Reference<?> mockReference;
    private HttpURLConnection mockHttpURLConnection;

    @Before
    public void mockitoNotSupportedOnJava21() {
        Assume.assumeTrue((Jvm.majorVersion() <= 17 ? 1 : 0) != 0);
    }

    @Before
    public void setUp() {
        this.mockitoNotSupportedOnJava21();
        this.mockCloseable = (Closeable)Mockito.mock(Closeable.class);
        CloseableUtils.enableCloseableTracing();
        this.mockCloseables = (Collection)Mockito.mock(Collection.class);
        this.mockServerSocketChannel = (ServerSocketChannel)Mockito.mock(ServerSocketChannel.class);
        this.mockAutoCloseable = (AutoCloseable)Mockito.mock(AutoCloseable.class);
        this.mockReference = (Reference)Mockito.mock(Reference.class);
        this.mockHttpURLConnection = (HttpURLConnection)Mockito.mock(HttpURLConnection.class);
    }

    @After
    public void tearDown() {
        CloseableUtils.disableCloseableTracing();
    }

    @Test
    public void testAdd() {
        CloseableUtils.add((Closeable)this.mockCloseable);
        AtomicReference<Set<Closeable>> closeablesRef = this.getCloseablesRef();
        Assert.assertTrue((boolean)closeablesRef.get().contains(this.mockCloseable));
    }

    @Test
    public void testEnableCloseableTracing() {
        Assert.assertNotNull(this.getCloseablesRef().get());
    }

    @Test
    public void testDisableCloseableTracing() {
        CloseableUtils.disableCloseableTracing();
        Assert.assertNull(this.getCloseablesRef().get());
    }

    private AtomicReference<Set<Closeable>> getCloseablesRef() {
        try {
            Field field = CloseableUtils.class.getDeclaredField("CLOSEABLES");
            field.setAccessible(true);
            return (AtomicReference)field.get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testWaitForCloseablesToClose() {
        CloseableUtils.add((Closeable)this.mockCloseable);
        Mockito.when((Object)this.mockCloseable.isClosing()).thenReturn((Object)true);
        Assert.assertTrue((boolean)CloseableUtils.waitForCloseablesToClose((long)1000L));
    }

    @Test(expected=IllegalStateException.class)
    public void testWaitForCloseablesToCloseWithException() {
        CloseableUtils.add((Closeable)this.mockCloseable);
        Mockito.when((Object)this.mockCloseable.isClosing()).thenReturn((Object)false);
        ((Closeable)Mockito.doThrow(IllegalStateException.class).when((Object)this.mockCloseable)).isClosing();
        CloseableUtils.waitForCloseablesToClose((long)1000L);
    }

    @Test
    public void testAssertCloseablesClosed() {
        CloseableUtils.add((Closeable)this.mockCloseable);
        Mockito.when((Object)this.mockCloseable.isClosed()).thenReturn((Object)true);
        CloseableUtils.assertCloseablesClosed();
    }

    @Test(expected=AssertionError.class)
    public void testAssertCloseablesClosedWithOpenCloseables() {
        CloseableUtils.add((Closeable)this.mockCloseable);
        Mockito.when((Object)this.mockCloseable.isClosed()).thenReturn((Object)false);
        CloseableUtils.assertCloseablesClosed();
    }

    @Test
    public void testUnmonitor() {
        CloseableUtils.add((Closeable)this.mockCloseable);
        CloseableUtils.unmonitor((Closeable)this.mockCloseable);
        AtomicReference<Set<Closeable>> closeablesRef = this.getCloseablesRef();
        Assert.assertFalse((boolean)closeablesRef.get().contains(this.mockCloseable));
    }

    @Test
    public void testCloseQuietlyArray() {
        Object[] array = new Object[]{Mockito.mock(Closeable.class), Mockito.mock(Closeable.class)};
        CloseableUtils.closeQuietly((Object[])array);
        for (Object o : array) {
            ((Closeable)Mockito.verify((Object)((Closeable)o), (VerificationMode)Mockito.times((int)1))).close();
        }
    }

    @Test
    public void testCloseQuietlyAutoCloseable() throws Exception {
        CloseableUtils.closeQuietly((Object)this.mockAutoCloseable);
        ((AutoCloseable)Mockito.verify((Object)this.mockAutoCloseable, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void testCloseQuietlyHttpURLConnection() {
        CloseableUtils.closeQuietly((Object)this.mockHttpURLConnection);
        ((HttpURLConnection)Mockito.verify((Object)this.mockHttpURLConnection, (VerificationMode)Mockito.times((int)1))).disconnect();
    }
}

