/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.internal.analytics;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import net.openhft.chronicle.core.internal.analytics.ReflectionUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ReflectionUtilTest {
    @Test
    public void analyticsPresentShouldReturnTrueOrFalse() {
        boolean result = ReflectionUtil.analyticsPresent();
        Assertions.assertTrue((result || !result ? 1 : 0) != 0, (String)"analyticsPresent should return true or false");
    }

    @Test
    public void methodOrThrowShouldReturnMethod() throws NoSuchMethodException {
        Method expected = String.class.getMethod("length", new Class[0]);
        Method actual = ReflectionUtil.methodOrThrow((String)"java.lang.String", (String)"length", (Class[])new Class[0]);
        Assertions.assertEquals((Object)expected, (Object)actual, (String)"methodOrThrow should return the correct method");
    }

    @Test
    public void invokeOrThrowShouldInvokeMethod() throws NoSuchMethodException {
        Method lengthMethod = String.class.getMethod("length", new Class[0]);
        Object result = ReflectionUtil.invokeOrThrow((Method)lengthMethod, (Object)"test", (Object[])new Object[0]);
        Assertions.assertEquals((Object)4, (Object)result, (String)"invokeOrThrow should correctly invoke the method and return the result");
    }

    @Test
    public void reflectiveProxyShouldCreateProxy() {
        TestInterface delegate = () -> "test";
        TestInterface proxy = (TestInterface)ReflectionUtil.reflectiveProxy(TestInterface.class, (Object)delegate);
        Assertions.assertTrue((boolean)Proxy.isProxyClass(proxy.getClass()), (String)"reflectiveProxy should create a proxy class");
        Assertions.assertEquals((Object)"test", (Object)proxy.testMethod(), (String)"reflectiveProxy should correctly delegate method calls");
    }

    @Test
    public void reflectiveProxyWithReturnProxyShouldReturnProxy() {
        TestInterface delegate = () -> "test";
        TestInterface proxy = (TestInterface)ReflectionUtil.reflectiveProxy(TestInterface.class, (Object)delegate, (boolean)true);
        Assertions.assertTrue((boolean)Proxy.isProxyClass(proxy.getClass()), (String)"reflectiveProxy should create a proxy class");
        Assertions.assertSame((Object)proxy, (Object)proxy.testMethod(), (String)"reflectiveProxy should return the proxy itself for chaining");
    }

    private static interface TestInterface {
        public Object testMethod();
    }
}

