/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.internal.analytics;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.openhft.chronicle.core.CoreTestCommon;
import net.openhft.chronicle.core.internal.analytics.StandardMaps;
import org.junit.Assert;
import org.junit.Test;

public class StandardMapsTest
extends CoreTestCommon {
    @Test
    public void standardEventParameters() {
        Assert.assertEquals(Collections.singletonMap("app_version", "1.0.0"), (Object)StandardMaps.standardEventParameters((String)"1.0.0"));
    }

    @Test
    public void standardAdditionalEventParametersThreadsStackTrace() {
        Map actual = StandardMaps.standardAdditionalEventParameters();
        Assert.assertFalse((boolean)actual.containsValue("java.lang"));
        Assert.assertFalse((boolean)actual.containsValue("org.junit"));
    }

    @Test
    public void standardAdditionalEventParameters() {
        StackTraceElement[] stackTrace = (StackTraceElement[])Stream.of("a.Foo", "software.chronicle.fix.demo.connections.example1.Main", "software.chronicle.fix.Runner", Thread.class.getName(), "software.chronicle.enterprise.E", "b.Foo", Method.class.getName(), "w.x.y.z.Foo", "jdk.internal.reflect.A", "java.util.concurrent.A", "org.apache.maven.A", List.class.getName()).map(s -> new StackTraceElement((String)s, "m", "m.java", 1)).toArray(StackTraceElement[]::new);
        LinkedHashMap<String, String> expected = new LinkedHashMap<String, String>();
        expected.put("package_name_0", "a");
        expected.put("package_name_1", "software.chronicle.fix.demo.connections.example1");
        expected.put("package_name_2", "b");
        Map actual = StandardMaps.standardAdditionalEventParameters((StackTraceElement[])stackTrace);
        Assert.assertEquals(expected, (Object)actual);
    }

    @Test
    public void standardUserProperties() {
        Assert.assertFalse((boolean)StandardMaps.standardUserProperties().values().stream().anyMatch(Objects::isNull));
    }

    @Test
    public void packageNameUpToMaxLevel3Empty() {
        Assert.assertEquals((Object)"", (Object)StandardMaps.packageNameUpToMaxLevel3((String)""));
    }

    @Test
    public void packageNameUpToMaxLevel3L0() {
        Assert.assertEquals((Object)"foo", (Object)StandardMaps.packageNameUpToMaxLevel3((String)"foo"));
    }

    @Test
    public void packageNameUpToMaxLevel3L1() {
        Assert.assertEquals((Object)"a", (Object)StandardMaps.packageNameUpToMaxLevel3((String)"a.foo"));
    }

    @Test
    public void packageNameUpToMaxLevel3L2() {
        Assert.assertEquals((Object)"a.b", (Object)StandardMaps.packageNameUpToMaxLevel3((String)"a.b.foo"));
    }

    @Test
    public void packageNameUpToMaxLevel3L3() {
        Assert.assertEquals((Object)"a.b.c", (Object)StandardMaps.packageNameUpToMaxLevel3((String)"a.b.c.foo"));
    }

    @Test
    public void packageNameUpToMaxLevel3L4() {
        Assert.assertEquals((Object)"a.b.c", (Object)StandardMaps.packageNameUpToMaxLevel3((String)"a.b.c.d.foo"));
    }

    @Test
    public void packageNameUpToMaxLevelThisClass() {
        Assert.assertEquals((Object)"net.openhft.chronicle", (Object)StandardMaps.packageNameUpToMaxLevel3((String)StandardMapsTest.class.getName()));
    }

    @Test
    public void distinctUpToMaxLevel3() {
        HashSet distinctKeys = new HashSet();
        List list = Stream.of("a.b.c.d", "a.b.c.d.e", "x", "y", "z").filter(pn -> StandardMaps.distinctUpToMaxLevel3((String)pn, (Set)distinctKeys)).collect(Collectors.toList());
        Assert.assertEquals(Arrays.asList("a.b.c.d", "x", "y", "z"), list);
    }
}

