/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.internal.util;

import net.openhft.chronicle.core.CoreTestCommon;
import net.openhft.chronicle.core.internal.util.VanillaThreadConfinementAsserter;
import net.openhft.chronicle.core.util.ThreadConfinementAsserter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class VanillaThreadConfinementAsserterTest
extends CoreTestCommon {
    private ThreadConfinementAsserter asserter;

    @Before
    public void before() {
        this.asserter = new VanillaThreadConfinementAsserter();
    }

    @Test
    public void assertThreadConfinedSame() {
        this.asserter.assertThreadConfined();
    }

    @Test
    public void assertThreadConfinedOther() throws InterruptedException {
        Thread other = new Thread(() -> this.asserter.assertThreadConfined(), "first");
        other.start();
        other.join();
        Assert.assertThrows(IllegalStateException.class, () -> this.asserter.assertThreadConfined());
    }

    @Test
    public void shouldNotThrowExceptionForSameThreadAccess() {
        VanillaThreadConfinementAsserter asserter = new VanillaThreadConfinementAsserter();
        Assertions.assertDoesNotThrow(() -> ((VanillaThreadConfinementAsserter)asserter).assertThreadConfined(), (String)"Access by the same thread should not throw an exception");
    }

    @Test
    public void shouldThrowExceptionForDifferentThreadAccess() throws InterruptedException {
        VanillaThreadConfinementAsserter asserter = new VanillaThreadConfinementAsserter();
        asserter.assertThreadConfined();
        Thread otherThread = new Thread(() -> Assert.assertThrows(IllegalStateException.class, () -> ((VanillaThreadConfinementAsserter)asserter).assertThreadConfined()));
        otherThread.start();
        otherThread.join();
    }

    @Test
    public void toStringShouldReturnNonNullValue() {
        VanillaThreadConfinementAsserter asserter = new VanillaThreadConfinementAsserter();
        Assertions.assertNotNull((Object)asserter.toString(), (String)"toString should return a non-null value");
    }
}

