/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.io;

import net.openhft.chronicle.core.io.SimpleCloseable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SimpleCloseableTest {
    @Test
    public void testClose() {
        TestableSimpleCloseable closeable = new TestableSimpleCloseable();
        Assertions.assertFalse((boolean)closeable.isClosed());
        closeable.close();
        Assertions.assertTrue((boolean)closeable.isClosed());
        Assertions.assertTrue((boolean)closeable.isPerformCloseCalled());
        closeable.close();
        Assertions.assertTrue((boolean)closeable.isClosed());
    }

    @Test
    public void testIsClosed() {
        TestableSimpleCloseable closeable = new TestableSimpleCloseable();
        Assertions.assertFalse((boolean)closeable.isClosed());
        closeable.close();
        Assertions.assertTrue((boolean)closeable.isClosed());
    }

    public static class TestableSimpleCloseable
    extends SimpleCloseable {
        private boolean performCloseCalled = false;

        protected void performClose() {
            if (!this.performCloseCalled) {
                super.performClose();
                this.performCloseCalled = true;
            }
        }

        boolean isPerformCloseCalled() {
            return this.performCloseCalled;
        }
    }
}

