/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.onoes;

import net.openhft.chronicle.core.onoes.ChainedExceptionHandler;
import net.openhft.chronicle.core.onoes.ExceptionHandler;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;

class ChainedExceptionHandlerTest {
    private ExceptionHandler handler1;
    private ExceptionHandler handler2;
    private ChainedExceptionHandler chainedHandler;

    ChainedExceptionHandlerTest() {
    }

    @BeforeEach
    void setUp() {
        this.handler1 = (ExceptionHandler)Mockito.mock(ExceptionHandler.class);
        this.handler2 = (ExceptionHandler)Mockito.mock(ExceptionHandler.class);
        this.chainedHandler = new ChainedExceptionHandler(new ExceptionHandler[]{this.handler1, this.handler2});
    }

    @Test
    void testChainExecution() {
        RuntimeException throwable = new RuntimeException("Test");
        this.chainedHandler.on(Exception.class, "Test message", (Throwable)throwable);
        ((ExceptionHandler)Mockito.verify((Object)this.handler1)).on(Exception.class, "Test message", (Throwable)throwable);
        ((ExceptionHandler)Mockito.verify((Object)this.handler2)).on(Exception.class, "Test message", (Throwable)throwable);
    }

    @Test
    void onWithClassShouldCallEachHandler() {
        ExceptionHandler firstHandler = (ExceptionHandler)Mockito.mock(ExceptionHandler.class);
        ExceptionHandler secondHandler = (ExceptionHandler)Mockito.mock(ExceptionHandler.class);
        ChainedExceptionHandler chained = new ChainedExceptionHandler(new ExceptionHandler[]{firstHandler, secondHandler});
        Class<String> clazz = String.class;
        String message = "Test message";
        RuntimeException thrown = new RuntimeException();
        chained.on(clazz, message, (Throwable)thrown);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{firstHandler, secondHandler});
        ((ExceptionHandler)inOrder.verify((Object)firstHandler)).on(clazz, message, (Throwable)thrown);
        ((ExceptionHandler)inOrder.verify((Object)secondHandler)).on(clazz, message, (Throwable)thrown);
    }

    @Test
    void onShouldCatchExceptionsFromHandlers() {
        ExceptionHandler faultyHandler = (clazz, msg, thr) -> {
            throw new RuntimeException("Handler error");
        };
        ChainedExceptionHandler chained = new ChainedExceptionHandler(new ExceptionHandler[]{faultyHandler});
        chained.on(String.class, "message", (Throwable)new RuntimeException());
    }
}

