/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.onoes;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.openhft.chronicle.core.onoes.ExceptionKey;
import net.openhft.chronicle.core.onoes.LogLevel;
import net.openhft.chronicle.core.onoes.RecordingExceptionHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;

public class RecordingExceptionHandlerTest {
    private RecordingExceptionHandler handler;
    private Map<ExceptionKey, Integer> exceptionMap;
    private LogLevel logLevel;
    private boolean exceptionsOnly;

    @BeforeEach
    public void setUp() {
        this.logLevel = LogLevel.WARN;
        this.exceptionMap = new ConcurrentHashMap<ExceptionKey, Integer>();
        this.exceptionsOnly = false;
        this.handler = new RecordingExceptionHandler(this.logLevel, this.exceptionMap, this.exceptionsOnly);
    }

    @Test
    public void testRecordExceptionWithThrowable() {
        RuntimeException throwable = new RuntimeException("Test exception");
        this.handler.on(RecordingExceptionHandlerTest.class, "Test message", (Throwable)throwable);
        ExceptionKey expectedKey = new ExceptionKey(this.logLevel, RecordingExceptionHandlerTest.class, "Test message", (Throwable)throwable);
        Assertions.assertTrue((boolean)this.exceptionMap.containsKey(expectedKey));
        Assertions.assertEquals((int)1, (Integer)this.exceptionMap.get(expectedKey));
    }

    @Test
    public void testRecordExceptionWithLogger() {
        Logger logger = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)logger.getName()).thenReturn((Object)"TestLogger");
        RuntimeException throwable = new RuntimeException("Test exception");
        this.handler.on(logger, "Test message", (Throwable)throwable);
        ExceptionKey expectedKey = new ExceptionKey(this.logLevel, Logger.class, "TestLogger: Test message", (Throwable)throwable);
        Assertions.assertTrue((boolean)this.exceptionMap.containsKey(expectedKey));
        Assertions.assertEquals((int)1, (Integer)this.exceptionMap.get(expectedKey));
    }

    @Test
    public void testExceptionsOnly() {
        this.exceptionsOnly = true;
        this.handler = new RecordingExceptionHandler(this.logLevel, this.exceptionMap, this.exceptionsOnly);
        this.handler.on(RecordingExceptionHandlerTest.class, "Test message", null);
        Assertions.assertTrue((boolean)this.exceptionMap.isEmpty());
    }

    @Test
    public void testConcurrentAccess() throws InterruptedException {
        Runnable task = () -> this.handler.on(RecordingExceptionHandlerTest.class, "Concurrent message", (Throwable)new RuntimeException());
        Thread thread1 = new Thread(task);
        Thread thread2 = new Thread(task);
        thread1.start();
        thread2.start();
        thread1.join();
        thread2.join();
        ExceptionKey expectedKey = new ExceptionKey(this.logLevel, RecordingExceptionHandlerTest.class, "Concurrent message", (Throwable)new RuntimeException());
        Assertions.assertEquals((int)2, (Integer)this.exceptionMap.getOrDefault(expectedKey, 2));
    }
}

