/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.onoes;

import net.openhft.chronicle.core.onoes.LogLevel;
import net.openhft.chronicle.core.onoes.Slf4jExceptionHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;

class Slf4jExceptionHandlerTest {
    private Logger logger;

    Slf4jExceptionHandlerTest() {
    }

    @BeforeEach
    void setUp() {
        this.logger = (Logger)Mockito.mock(Logger.class);
    }

    @Test
    void testErrorLogLevel() {
        RuntimeException throwable = new RuntimeException("Test exception");
        Slf4jExceptionHandler.ERROR.on(this.logger, "Error message", (Throwable)throwable);
        ((Logger)Mockito.verify((Object)this.logger)).error("Error message", (Throwable)throwable);
    }

    @Test
    void testWarnLogLevel() {
        RuntimeException throwable = new RuntimeException("Test exception");
        Slf4jExceptionHandler.WARN.on(this.logger, "Warn message", (Throwable)throwable);
        ((Logger)Mockito.verify((Object)this.logger)).warn("Warn message", (Throwable)throwable);
    }

    @Test
    void testPerfLogLevel() {
        RuntimeException throwable = new RuntimeException("Test exception");
        Slf4jExceptionHandler.PERF.on(this.logger, "Perf message", (Throwable)throwable);
        ((Logger)Mockito.verify((Object)this.logger)).info("Perf message", (Throwable)throwable);
    }

    @Test
    void testDebugLogLevel() {
        RuntimeException throwable = new RuntimeException("Test exception");
        Slf4jExceptionHandler.DEBUG.on(this.logger, "Debug message", (Throwable)throwable);
        ((Logger)Mockito.verify((Object)this.logger)).debug("Debug message", (Throwable)throwable);
    }

    @Test
    void testValueOfLogLevel() {
        Assertions.assertEquals((Object)Slf4jExceptionHandler.ERROR, (Object)Slf4jExceptionHandler.valueOf((LogLevel)LogLevel.ERROR));
        Assertions.assertEquals((Object)Slf4jExceptionHandler.WARN, (Object)Slf4jExceptionHandler.valueOf((LogLevel)LogLevel.WARN));
        Assertions.assertEquals((Object)Slf4jExceptionHandler.PERF, (Object)Slf4jExceptionHandler.valueOf((LogLevel)LogLevel.PERF));
        Assertions.assertEquals((Object)Slf4jExceptionHandler.DEBUG, (Object)Slf4jExceptionHandler.valueOf((LogLevel)LogLevel.DEBUG));
    }
}

