/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.pool;

import net.openhft.chronicle.core.CoreTestCommon;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.core.threads.ThreadDump;
import net.openhft.chronicle.core.util.ClassNotFoundRuntimeException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ClassAliasPoolTest
extends CoreTestCommon {
    private ThreadDump threadDump;

    @Override
    @Before
    public void threadDump() {
        this.threadDump = new ThreadDump();
    }

    @Override
    @After
    public void checkThreadDump() {
        this.threadDump.assertNoNewThreads();
    }

    @Test
    public void forName() {
        ClassAliasPool.CLASS_ALIASES.addAlias(new Class[]{ClassAliasPoolTest.class});
        String simpleName = this.getClass().getSimpleName();
        Assert.assertEquals(ClassAliasPoolTest.class, (Object)ClassAliasPool.CLASS_ALIASES.forName((CharSequence)simpleName));
        StringBuilder sb = new StringBuilder(simpleName);
        Assert.assertEquals(ClassAliasPoolTest.class, (Object)ClassAliasPool.CLASS_ALIASES.forName((CharSequence)sb));
    }

    @Test
    public void testClean() throws IllegalArgumentException {
        Assert.assertEquals((Object)"String", (Object)ClassAliasPool.CLASS_ALIASES.nameFor(String.class));
        ClassAliasPool.CLASS_ALIASES.clean();
        Assert.assertEquals((Object)"String", (Object)ClassAliasPool.CLASS_ALIASES.nameFor(String.class));
    }

    @Test
    public void testEnum() throws IllegalArgumentException {
        Assert.assertEquals((Object)"net.openhft.chronicle.core.pool.ClassAliasPoolTest$TestEnum", (Object)ClassAliasPool.CLASS_ALIASES.nameFor(TestEnum.class));
        Assert.assertEquals((Object)"net.openhft.chronicle.core.pool.ClassAliasPoolTest$TestEnum", (Object)ClassAliasPool.CLASS_ALIASES.nameFor(((Object)((Object)TestEnum.FOO)).getClass()));
        Assert.assertEquals((Object)"net.openhft.chronicle.core.pool.ClassAliasPoolTest$TestEnum", (Object)ClassAliasPool.CLASS_ALIASES.nameFor(((Object)((Object)TestEnum.BAR)).getClass()));
    }

    @Test
    public void replace() {
        this.expectException("Replaced class net.openhft.chronicle.core.pool.ClassAliasPoolTest with class net.openhft.chronicle.core.pool.ClassAliasPoolTest$TestEnum");
        ClassAliasPool.CLASS_ALIASES.addAlias(ClassAliasPoolTest.class, "name1");
        ClassAliasPool.CLASS_ALIASES.addAlias(TestEnum.class, "name1");
    }

    @Test
    public void wrongCaseClassName() {
        Assert.assertThrows(ClassNotFoundRuntimeException.class, () -> ClassAliasPool.CLASS_ALIASES.forName((CharSequence)TestEnum.class.getName().toLowerCase()));
    }

    @Test
    public void banned() {
        for (int i = 0; i < 2; ++i) {
            Assert.assertThrows(ClassNotFoundRuntimeException.class, () -> ClassAliasPool.CLASS_ALIASES.forName((CharSequence)"com.sun.xml.internal.bind.v2.runtime.unmarshaller.Base64Data"));
            Assert.assertThrows(ClassNotFoundRuntimeException.class, () -> ClassAliasPool.CLASS_ALIASES.forName((CharSequence)"com.sun.istack.internal.ByteArrayDataSource"));
            Assert.assertThrows(ClassNotFoundRuntimeException.class, () -> ClassAliasPool.CLASS_ALIASES.forName((CharSequence)"com.oracle.webservices.internal.api.databinding.DatabindingFactory"));
            Assert.assertThrows(ClassNotFoundRuntimeException.class, () -> ClassAliasPool.CLASS_ALIASES.forName((CharSequence)"jdk.internal.util.xml.SAXParser"));
            Assert.assertThrows(ClassNotFoundRuntimeException.class, () -> ClassAliasPool.CLASS_ALIASES.forName((CharSequence)"sun.corba.SharedSecrets"));
        }
    }

    static enum TestEnum {
        FOO{

            @Override
            void foo() {
            }
        }
        ,
        BAR;


        void foo() {
        }
    }
}

