/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.pool;

import java.util.stream.Stream;
import net.openhft.chronicle.core.CoreTestCommon;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.pool.EnumInterner;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class EnumInternerTest
extends CoreTestCommon {
    static final int MASK = 63;

    public static void main(String[] args) {
        for (int i = 0; i < 100000; ++i) {
            int h;
            String s = Long.toString(i, 36);
            if (!Character.isJavaIdentifierStart(s.charAt(0))) continue;
            long h1 = Maths.hash64((String)s);
            if ((h = (int)(h1 ^= h1 >> 32) & 0x3F) != 0) continue;
            System.out.println(s + ",");
        }
    }

    @Test
    public void clashTest() {
        for (TestEnum value : TestEnum.values()) {
            @NotNull String s = value.toString();
            long h = Maths.hash64((String)s);
            h ^= h >> 32;
            Assertions.assertEquals((int)0, (int)((int)h & 0x3F));
        }
        EnumInterner testEnum = new EnumInterner(TestEnum.class);
        ((Stream)Stream.of(TestEnum.values()).parallel()).forEach(te -> {
            String cs = te.toString();
            for (int i = 0; i < 20000; ++i) {
                TestEnum interned = (TestEnum)testEnum.intern((CharSequence)cs);
                Assert.assertEquals((String)("i: " + i), (Object)((Object)interned), (Object)te);
            }
        });
    }

    static enum TestEnum {
        c1,
        cq,
        db,
        ho,
        id,
        k6,
        kv,
        la,
        m5,
        mu,
        nb,
        qg,
        s8,
        sx,
        uz,
        va,
        yj;

    }
}

