/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.scoped;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import net.openhft.chronicle.core.CoreTestCommon;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.scoped.ScopedResource;
import net.openhft.chronicle.core.scoped.ScopedThreadLocal;
import net.openhft.chronicle.core.threads.CleaningThread;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ScopedThreadLocalTest
extends CoreTestCommon {
    private static final int MAX_INSTANCES = 3;
    private ScopedThreadLocal<AtomicLong> scopedThreadLocal;

    @Before
    public void createSTL() {
        this.scopedThreadLocal = new ScopedThreadLocal(AtomicLong::new, al -> al.set(0L), 3);
    }

    @Test
    public void warningWillBeDisplayedWhenWeUseMoreThanMaxInstances() {
        this.expectException("Pool capacity exceeded, consider increasing maxInstances, maxInstances=3");
        ArrayList<ScopedResource> allLongs = new ArrayList<ScopedResource>();
        for (int i = 0; i < 4; ++i) {
            allLongs.add(this.scopedThreadLocal.get());
        }
        net.openhft.chronicle.core.io.Closeable.closeQuietly(allLongs);
    }

    @Test
    public void nestedCallsWillGetDifferentResources() {
        try (ScopedResource l1 = this.scopedThreadLocal.get();){
            ((AtomicLong)l1.get()).set(123L);
            try (ScopedResource l2 = this.scopedThreadLocal.get();){
                ((AtomicLong)l2.get()).set(456L);
                try (ScopedResource l3 = this.scopedThreadLocal.get();){
                    ((AtomicLong)l3.get()).set(789L);
                }
                Assert.assertEquals((long)456L, (long)((AtomicLong)l2.get()).get());
            }
            Assert.assertEquals((long)123L, (long)((AtomicLong)l1.get()).get());
        }
    }

    @Test
    public void differentThreadsWillGetDifferentResources() throws InterruptedException {
        HashSet instanceObjectIDs = new HashSet();
        int numThreads = 10;
        for (int i = 0; i < 10; ++i) {
            CleaningThread thread = new CleaningThread(() -> {
                try (ScopedResource resource = this.scopedThreadLocal.get();){
                    if (resource == null) {
                        throw new IllegalStateException();
                    }
                    int e = System.identityHashCode(resource.get());
                    instanceObjectIDs.add(e);
                }
                catch (Exception e) {
                    Jvm.error().on(ScopedThreadLocalTest.class, (Throwable)e);
                }
            });
            thread.start();
            thread.join();
        }
        Assert.assertEquals((long)10L, (long)instanceObjectIDs.size());
    }

    @Test
    public void onAcquireIsPerformedBeforeEachAcquisition() {
        int objectId;
        try (ScopedResource l1 = this.scopedThreadLocal.get();){
            ((AtomicLong)l1.get()).set(123L);
            objectId = System.identityHashCode(l1.get());
        }
        l1 = this.scopedThreadLocal.get();
        var3_2 = null;
        try {
            Assert.assertEquals((long)0L, (long)((AtomicLong)l1.get()).get());
            Assert.assertEquals((long)objectId, (long)System.identityHashCode(l1.get()));
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
        finally {
            if (l1 != null) {
                if (var3_2 != null) {
                    try {
                        l1.close();
                    }
                    catch (Throwable throwable) {
                        var3_2.addSuppressed(throwable);
                    }
                } else {
                    l1.close();
                }
            }
        }
    }

    @Test
    public void cleaningThreadWillCloseResources() throws InterruptedException {
        ArrayList allResources = new ArrayList();
        ScopedThreadLocal stl = new ScopedThreadLocal(() -> {
            CloseableResource cr = new CloseableResource();
            allResources.add(cr);
            return cr;
        }, 2);
        CleaningThread cleaningThread = new CleaningThread(() -> {
            try (ScopedResource cr1 = stl.get();){
                ScopedResource cr2 = stl.get();
                Throwable throwable = null;
                if (cr2 != null) {
                    if (throwable != null) {
                        try {
                            cr2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    } else {
                        cr2.close();
                    }
                }
            }
            Assert.assertTrue((boolean)allResources.stream().noneMatch(cr -> ((CloseableResource)cr).closed));
        });
        cleaningThread.start();
        cleaningThread.join();
        Assert.assertEquals((long)2L, (long)allResources.size());
        Assert.assertTrue((boolean)allResources.stream().allMatch(cr -> ((CloseableResource)cr).closed));
    }

    @Test
    public void whenOverflowOccursNewestInstanceIsDiscarded() {
        this.expectException("Pool capacity exceeded, consider increasing maxInstances, maxInstances=3");
        AtomicInteger values = new AtomicInteger(0);
        ScopedThreadLocal ints = new ScopedThreadLocal(values::getAndIncrement, i -> {}, 3);
        Assert.assertEquals(new HashSet<Integer>(Arrays.asList(0, 1, 2, 3)), this.retrieveAndReturnNValues(4, (ScopedThreadLocal<Integer>)ints));
        Assert.assertEquals(new HashSet<Integer>(Arrays.asList(0, 1, 2, 4, 5)), this.retrieveAndReturnNValues(5, (ScopedThreadLocal<Integer>)ints));
        Assert.assertEquals(new HashSet<Integer>(Arrays.asList(0, 1, 2, 6, 7)), this.retrieveAndReturnNValues(5, (ScopedThreadLocal<Integer>)ints));
    }

    private Set<Integer> retrieveAndReturnNValues(int numberToRetrieve, ScopedThreadLocal<Integer> scopedInts) {
        HashSet<Integer> values = new HashSet<Integer>();
        this.retrieveAndRecord(values, scopedInts, numberToRetrieve);
        return values;
    }

    private void retrieveAndRecord(Set<Integer> values, ScopedThreadLocal<Integer> scopedInts, int depth) {
        if (depth > 0) {
            try (ScopedResource isr = scopedInts.get();){
                values.add((Integer)isr.get());
                this.retrieveAndRecord(values, scopedInts, depth - 1);
            }
        }
    }

    private static class CloseableResource
    implements Closeable {
        private boolean closed = false;

        private CloseableResource() {
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

