/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.threads;

import net.openhft.chronicle.core.threads.DelegatingEventLoop;
import net.openhft.chronicle.core.threads.EventHandler;
import net.openhft.chronicle.core.threads.EventLoop;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class DelegatingEventLoopTest {
    private EventLoop innerEventLoop;
    private DelegatingEventLoop delegatingEventLoop;

    DelegatingEventLoopTest() {
    }

    @BeforeEach
    void setUp() {
        this.innerEventLoop = (EventLoop)Mockito.mock(EventLoop.class);
        this.delegatingEventLoop = new DelegatingEventLoop(this.innerEventLoop);
    }

    @Test
    void constructorShouldAssignEventLoop() {
        Assertions.assertEquals((Object)this.innerEventLoop, (Object)this.delegatingEventLoop.inner);
    }

    @Test
    void nameShouldDelegateToInner() {
        this.delegatingEventLoop.name();
        ((EventLoop)Mockito.verify((Object)this.innerEventLoop)).name();
    }

    @Test
    void startShouldDelegateToInner() {
        this.delegatingEventLoop.start();
        ((EventLoop)Mockito.verify((Object)this.innerEventLoop)).start();
    }

    @Test
    void unpauseShouldDelegateToInner() {
        this.delegatingEventLoop.unpause();
        ((EventLoop)Mockito.verify((Object)this.innerEventLoop)).unpause();
    }

    @Test
    void stopShouldDelegateToInner() {
        this.delegatingEventLoop.stop();
        ((EventLoop)Mockito.verify((Object)this.innerEventLoop)).stop();
    }

    @Test
    void isClosedShouldDelegateToInner() {
        this.delegatingEventLoop.isClosed();
        ((EventLoop)Mockito.verify((Object)this.innerEventLoop)).isClosed();
    }

    @Test
    void isStoppedShouldDelegateToInner() {
        this.delegatingEventLoop.isStopped();
        ((EventLoop)Mockito.verify((Object)this.innerEventLoop)).isStopped();
    }

    @Test
    void isClosingShouldDelegateToInner() {
        this.delegatingEventLoop.isClosing();
        ((EventLoop)Mockito.verify((Object)this.innerEventLoop)).isClosing();
    }

    @Test
    void isAliveShouldDelegateToInner() {
        this.delegatingEventLoop.isAlive();
        ((EventLoop)Mockito.verify((Object)this.innerEventLoop)).isAlive();
    }

    @Test
    void closeShouldDelegateToInner() {
        this.delegatingEventLoop.close();
        ((EventLoop)Mockito.verify((Object)this.innerEventLoop)).close();
    }

    @Test
    void addHandlerShouldDelegateToInner() {
        EventHandler handler = (EventHandler)Mockito.mock(EventHandler.class);
        this.delegatingEventLoop.addHandler(handler);
        ((EventLoop)Mockito.verify((Object)this.innerEventLoop)).addHandler(handler);
    }

    @Test
    void runsInsideCoreLoopShouldDelegateToInner() {
        this.delegatingEventLoop.runsInsideCoreLoop();
        ((EventLoop)Mockito.verify((Object)this.innerEventLoop)).runsInsideCoreLoop();
    }
}

