/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.threads;

import java.io.Closeable;
import java.io.IOException;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.threads.EventHandler;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.core.threads.HandlerPriority;
import org.junit.Assert;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

class EventHandlerTest {
    EventHandlerTest() {
    }

    @BeforeEach
    public void mockitoNotSupportedOnJava21() {
        Assumptions.assumeTrue((Jvm.majorVersion() <= 17 ? 1 : 0) != 0);
    }

    @Test
    void eventLoopShouldBeCalledWithCorrectEventLoop() {
        EventLoop mockEventLoop = (EventLoop)Mockito.mock(EventLoop.class);
        EventHandler handler = (EventHandler)Mockito.mock(EventHandler.class, (Answer)Mockito.CALLS_REAL_METHODS);
        handler.eventLoop(mockEventLoop);
        ((EventHandler)Mockito.verify((Object)handler)).eventLoop(mockEventLoop);
    }

    @Test
    void loopStartedShouldBeCalled() {
        EventHandler handler = (EventHandler)Mockito.mock(EventHandler.class, (Answer)Mockito.CALLS_REAL_METHODS);
        handler.loopStarted();
        ((EventHandler)Mockito.verify((Object)handler)).loopStarted();
    }

    @Test
    void loopFinishedShouldBeCalled() {
        EventHandler handler = (EventHandler)Mockito.mock(EventHandler.class, (Answer)Mockito.CALLS_REAL_METHODS);
        handler.loopFinished();
        ((EventHandler)Mockito.verify((Object)handler)).loopFinished();
    }

    @Test
    void priorityShouldReturnMediumByDefault() {
        EventHandler handler = (EventHandler)Mockito.mock(EventHandler.class, (Answer)Mockito.CALLS_REAL_METHODS);
        Assert.assertEquals((Object)HandlerPriority.MEDIUM, (Object)handler.priority());
    }

    @Test
    void closeShouldBeCalledIfEventHandlerIsCloseable() throws IOException {
        EventHandler handler = (EventHandler)Mockito.mock(EventHandler.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{Closeable.class}));
        handler.loopFinished();
        ((Closeable)handler).close();
        ((Closeable)Mockito.verify((Object)((Closeable)handler))).close();
    }
}

