/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.threads;

import net.openhft.chronicle.core.threads.InterruptedRuntimeException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class InterruptedRuntimeExceptionTest {
    InterruptedRuntimeExceptionTest() {
    }

    @Test
    void defaultConstructorShouldCreateExceptionWithNoMessageOrCause() {
        InterruptedRuntimeException exception = new InterruptedRuntimeException();
        Assertions.assertNull((Object)exception.getMessage());
        Assertions.assertNull((Object)exception.getCause());
    }

    @Test
    void constructorWithMessageShouldSetCorrectMessage() {
        String message = "Interrupted";
        InterruptedRuntimeException exception = new InterruptedRuntimeException(message);
        Assertions.assertEquals((Object)message, (Object)exception.getMessage());
        Assertions.assertNull((Object)exception.getCause());
    }

    @Test
    void constructorWithMessageAndCauseShouldSetBothCorrectly() {
        String message = "Interrupted";
        RuntimeException cause = new RuntimeException("Cause");
        InterruptedRuntimeException exception = new InterruptedRuntimeException(message, (Throwable)cause);
        Assertions.assertEquals((Object)message, (Object)exception.getMessage());
        Assertions.assertEquals((Object)cause, (Object)exception.getCause());
    }

    @Test
    void constructorWithCauseShouldSetCauseAndDeriveMessage() {
        RuntimeException cause = new RuntimeException("Cause");
        InterruptedRuntimeException exception = new InterruptedRuntimeException((Throwable)cause);
        Assertions.assertEquals((Object)cause.toString(), (Object)exception.getMessage());
        Assertions.assertEquals((Object)cause, (Object)exception.getCause());
    }
}

