/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.threads;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.stream.Stream;
import net.openhft.chronicle.core.CoreTestCommon;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class InvalidEventHandlerExceptionTest
extends CoreTestCommon {
    InvalidEventHandlerException e;

    @Test
    public void testStandardConstructors() {
        String message = "Error occurred";
        RuntimeException cause = new RuntimeException("Cause of error");
        InvalidEventHandlerException exceptionWithMessage = new InvalidEventHandlerException(message);
        Assert.assertEquals((Object)message, (Object)exceptionWithMessage.getMessage());
        InvalidEventHandlerException exceptionWithCause = new InvalidEventHandlerException((Throwable)cause);
        Assertions.assertSame((Object)cause, (Object)exceptionWithCause.getCause());
        InvalidEventHandlerException defaultException = new InvalidEventHandlerException();
        Assertions.assertNull((Object)defaultException.getMessage());
    }

    @Test
    public void testReusableInstance() {
        InvalidEventHandlerException reusableInstance = InvalidEventHandlerException.reusable();
        Assertions.assertNotNull((Object)reusableInstance);
        Assert.assertEquals((long)0L, (long)reusableInstance.getStackTrace().length);
        RuntimeException newCause = new RuntimeException("New cause");
        Assertions.assertSame((Object)reusableInstance, (Object)reusableInstance.initCause((Throwable)newCause));
        Assertions.assertNull((Object)reusableInstance.getCause());
        reusableInstance.setStackTrace(new StackTraceElement[0]);
        Assert.assertEquals((long)0L, (long)reusableInstance.getStackTrace().length);
    }

    @Before
    public void setup() {
        this.e = InvalidEventHandlerException.reusable();
    }

    @Test
    public void stacktrace() {
        Assert.assertEquals((long)0L, (long)this.e.getStackTrace().length);
        StackTraceElement[] newStackTrace = (StackTraceElement[])Stream.of(new StackTraceElement("A", "foo", "A.java", 42)).toArray(StackTraceElement[]::new);
        this.e.setStackTrace(newStackTrace);
        Assert.assertEquals((long)0L, (long)this.e.getStackTrace().length);
    }

    @Test
    public void printStackTrace() throws IOException {
        final StringBuilder sb = new StringBuilder();
        try (OutputStream os = new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                sb.append((char)b);
            }
        };
             PrintStream ps = new PrintStream(os);){
            this.e.printStackTrace(ps);
        }
        String stackTrace = sb.toString();
        Assert.assertTrue((boolean)stackTrace.contains("Reusable"));
        Assert.assertTrue((boolean)stackTrace.contains("no stack trace"));
    }

    @Test
    public void toStringTest() {
        Assert.assertTrue((boolean)this.e.toString().contains("Reusable"));
        Assert.assertTrue((boolean)this.e.toString().contains("no stack trace"));
    }
}

