/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.util;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Method;
import net.openhft.chronicle.core.util.Annotations;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class AnnotationsTest {
    @Test
    public void findAnnotation_OnMethod() {
        TestAnnotation annotation = (TestAnnotation)Annotations.findAnnotation(TestAnnotation.class, TestClass.class, (String)"interfaceMethod", (Class[])new Class[0]);
        Assert.assertNotNull((Object)annotation);
    }

    @Test
    public void findAnnotation_NotPresent() {
        TestAnnotation annotation = (TestAnnotation)Annotations.findAnnotation(TestAnnotation.class, TestClass.class, (String)"testMethod", (Class[])new Class[0]);
        Assert.assertNull((Object)annotation);
    }

    @Test
    public void getAnnotation_DirectlyOnMethod() throws NoSuchMethodException {
        Method method = TestClass.class.getMethod("interfaceMethod", new Class[0]);
        TestAnnotation annotation = (TestAnnotation)Annotations.getAnnotation((Method)method, TestAnnotation.class);
        Assert.assertNotNull((Object)annotation);
    }

    @Test
    public void getAnnotation_NotPresent() throws NoSuchMethodException {
        Method method = TestClass.class.getMethod("testMethod", new Class[0]);
        TestAnnotation annotation = (TestAnnotation)Annotations.getAnnotation((Method)method, TestAnnotation.class);
        Assert.assertNull((Object)annotation);
    }

    public static class TestClass
    extends SuperClass
    implements TestInterface {
        public void testMethod() {
        }

        @Override
        public void interfaceMethod() {
        }
    }

    public static class SuperClass {
        public void superMethod() {
        }
    }

    public static interface TestInterface {
        @TestAnnotation
        public void interfaceMethod();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface TestAnnotation {
    }
}

