/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.util;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Map;
import net.openhft.chronicle.core.CoreTestCommon;
import net.openhft.chronicle.core.internal.invariant.ints.IntCondition;
import org.junit.Assert;
import org.junit.Test;

public class IntConditionTest
extends CoreTestCommon {
    @Test
    public void positive() {
        this.test(IntCondition.POSITIVE, IntCondition.NON_POSITIVE, IntConditionTest.entry(-1, false), IntConditionTest.entry(0, false), IntConditionTest.entry(1, true));
    }

    @Test
    public void negative() {
        this.test(IntCondition.NEGATIVE, IntCondition.NON_NEGATIVE, IntConditionTest.entry(-1, true), IntConditionTest.entry(0, false), IntConditionTest.entry(1, false));
    }

    @Test
    public void zero() {
        this.test(IntCondition.ZERO, IntCondition.NON_ZERO, IntConditionTest.entry(-1, false), IntConditionTest.entry(0, true), IntConditionTest.entry(1, false));
    }

    @Test
    public void byteConvertible() {
        this.test(IntCondition.BYTE_CONVERTIBLE, IntConditionTest.entry(-129, false), IntConditionTest.entry(-128, true), IntConditionTest.entry(0, true), IntConditionTest.entry(127, true), IntConditionTest.entry(128, false));
    }

    @Test
    public void shortConvertible() {
        this.test(IntCondition.SHORT_CONVERTIBLE, IntConditionTest.entry(-32769, false), IntConditionTest.entry(Short.MIN_VALUE, true), IntConditionTest.entry(0, true), IntConditionTest.entry(Short.MAX_VALUE, true), IntConditionTest.entry(32768, false));
    }

    @Test
    public void evenPowerOfTwo() {
        this.test(IntCondition.EVEN_POWER_OF_TWO, IntConditionTest.entry(0, false), IntConditionTest.entry(1, true), IntConditionTest.entry(2, true), IntConditionTest.entry(4, true), IntConditionTest.entry(Integer.MAX_VALUE, false), IntConditionTest.entry(Integer.MIN_VALUE, false), IntConditionTest.entry(-2, false));
    }

    private void test(IntCondition predicate, IntCondition negatedPredicate, Map.Entry<Integer, Boolean> ... expected) {
        Assert.assertEquals((Object)predicate.negate(), (Object)negatedPredicate);
        Arrays.stream(expected).forEach(e -> {
            Assert.assertEquals((String)(e.getKey() + " expected " + e.getValue()), e.getValue(), (Object)predicate.test(((Integer)e.getKey()).intValue()));
            Assert.assertNotEquals((String)(e.getKey() + " expected " + ((Boolean)e.getValue() == false)), e.getValue(), (Object)negatedPredicate.test(((Integer)e.getKey()).intValue()));
        });
    }

    private void test(IntCondition predicate, Map.Entry<Integer, Boolean> ... expected) {
        Arrays.stream(expected).forEach(e -> Assert.assertEquals((String)(e.getKey() + " expected " + e.getValue()), e.getValue(), (Object)predicate.test(((Integer)e.getKey()).intValue())));
    }

    private static Map.Entry<Integer, Boolean> entry(int value, boolean expected) {
        return new AbstractMap.SimpleImmutableEntry<Integer, Boolean>(value, expected);
    }
}

