/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.util;

import net.openhft.chronicle.core.util.IntTriPredicate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class IntTriPredicateTest {
    IntTriPredicateTest() {
    }

    @Test
    void testShouldReturnCorrectResult() {
        IntTriPredicate predicate = (t, u, v) -> t > u && u > v;
        Assertions.assertTrue((boolean)predicate.test(3, 2, 1));
        Assertions.assertFalse((boolean)predicate.test(1, 2, 3));
    }

    @Test
    void andShouldCombineTwoPredicates() {
        IntTriPredicate predicate1 = (t, u, v) -> t > u;
        IntTriPredicate predicate2 = (t, u, v) -> u > v;
        IntTriPredicate combined = predicate1.and(predicate2);
        Assertions.assertTrue((boolean)combined.test(3, 2, 1));
        Assertions.assertFalse((boolean)combined.test(1, 2, 3));
    }

    @Test
    void negateShouldInvertPredicate() {
        IntTriPredicate predicate = (t, u, v) -> t > u && u > v;
        IntTriPredicate negated = predicate.negate();
        Assertions.assertFalse((boolean)negated.test(3, 2, 1));
        Assertions.assertTrue((boolean)negated.test(1, 2, 3));
    }

    @Test
    void orShouldCombineTwoPredicates() {
        IntTriPredicate predicate1 = (t, u, v) -> t > u;
        IntTriPredicate predicate2 = (t, u, v) -> u > v;
        IntTriPredicate combined = predicate1.or(predicate2);
        Assertions.assertTrue((boolean)combined.test(2, 3, 1));
        Assertions.assertTrue((boolean)combined.test(3, 1, 2));
        Assertions.assertFalse((boolean)combined.test(1, 2, 3));
    }
}

