/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.util;

import net.openhft.chronicle.core.CoreTestCommon;
import net.openhft.chronicle.core.util.Histogram;
import net.openhft.chronicle.core.util.RecordingHistogram;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Test;

public class RecordingHistogramTest
extends CoreTestCommon {
    @Test
    public void singleSample() {
        int i;
        MyRecordingHistogram h = new MyRecordingHistogram();
        h.sampleNanos(100000L);
        Assert.assertEquals((Object)"{ 50/90 99/99.9 99.99 - worst  was: 100.0 / 100.0  100.0 / 100.0  100.0 - 100.0, top: [{ off: 1.0, dur: 100.0 }] }", (Object)h.toMicrosFormat());
        for (i = 1; i <= 10; ++i) {
            h.sampleNanos((long)i * 100000L);
        }
        for (i = 19; i > 0; i -= 2) {
            h.sampleNanos((long)i * 50000L);
        }
        Assert.assertEquals((Object)"{ 50/90 99/99.9 99.99 - worst  was: 500 / 900  1000 / 1000  1000 - 1000, top: [{ off: 10.0, dur: 1000.0 }, { off: 11.0, dur: 950.0 }, { off: 9.0, dur: 900.0 }, { off: 12.0, dur: 850.0 }, { off: 8.0, dur: 800.0 }] }", (Object)h.toMicrosFormat());
    }

    @Test
    public void testSampleNanosAndTopDurations() {
        RecordingHistogram histogram = new RecordingHistogram();
        histogram.sampleNanos(100L);
        histogram.sampleNanos(200L);
        histogram.sampleNanos(50L);
        histogram.sampleNanos(300L);
    }

    @Test
    public void testReset() {
        RecordingHistogram histogram = new RecordingHistogram();
        histogram.sampleNanos(100L);
        histogram.reset();
    }

    @Test
    public void testSamples() {
        int i;
        MyRecordingHistogram h = new MyRecordingHistogram();
        long seed = 2141L;
        for (i = 0; i <= 500; ++i) {
            h.sampleNanos(seed);
            if ((seed += 128981L) <= 1000000L) continue;
            seed -= 1000000L;
        }
        for (i = 1; i <= 100; ++i) {
            Assert.assertEquals((float)i, (float)this.percentile((Histogram)h, (double)i / 100.0), (float)1.0f);
        }
        Assert.assertEquals((Object)"{ 50/90 99/99.9 99.99 - worst  was: 500 / 900  990 / 998  998 - 998, top: [{ off: 32.0, dur: 998.963 }, { off: 36.0, dur: 997.374 }, { off: 39.0, dur: 995.785 }, { off: 41.0, dur: 994.196 }, { off: 43.0, dur: 992.607 }] }", (Object)h.toMicrosFormat());
        Assert.assertEquals((Object)"{ 50/90 97/99 99.7/99.9 99.97/99.99 - worst  was: 500 / 900  970 / 990  996 / 998  998 / 998 - 998, top: [{ off: 32.0, dur: 998.963 }, { off: 36.0, dur: 997.374 }, { off: 39.0, dur: 995.785 }, { off: 41.0, dur: 994.196 }, { off: 43.0, dur: 992.607 }, { off: 44.0, dur: 991.018 }, { off: 45.0, dur: 989.429 }, { off: 46.0, dur: 987.84 }, { off: 47.0, dur: 986.251 }, { off: 48.0, dur: 984.662 }] }", (Object)h.toLongMicrosFormat());
    }

    private int percentile(@NotNull Histogram h, double fraction) {
        return (int)h.percentile(fraction) / 10000;
    }

    private static class MyRecordingHistogram
    extends RecordingHistogram {
        long timeNS = 0L;

        private MyRecordingHistogram() {
        }

        protected long currentTimeNanos() {
            return this.timeNS += 1000L;
        }
    }
}

