/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.values;

import net.openhft.chronicle.core.values.LongValueImpl;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class LongValueImplTest {
    LongValueImplTest() {
    }

    @Test
    void testSetValueAndGetValue() {
        LongValueImpl longValue = new LongValueImpl();
        longValue.setValue(10L);
        Assertions.assertEquals((long)10L, (long)longValue.getValue());
    }

    @Test
    void testAddValue() {
        LongValueImpl longValue = new LongValueImpl();
        longValue.setValue(5L);
        longValue.addValue(3L);
        Assertions.assertEquals((long)8L, (long)longValue.getValue());
    }

    @Test
    void testCompareAndSwapValueSuccess() {
        LongValueImpl longValue = new LongValueImpl();
        longValue.setValue(15L);
        Assertions.assertTrue((boolean)longValue.compareAndSwapValue(15L, 20L));
        Assertions.assertEquals((long)20L, (long)longValue.getValue());
    }

    @Test
    void testCompareAndSwapValueFailure() {
        LongValueImpl longValue = new LongValueImpl();
        longValue.setValue(15L);
        Assertions.assertFalse((boolean)longValue.compareAndSwapValue(10L, 20L));
        Assertions.assertEquals((long)15L, (long)longValue.getValue());
    }

    @Test
    void testSetMaxValue() {
        LongValueImpl longValue = new LongValueImpl();
        longValue.setValue(50L);
        longValue.setMaxValue(100L);
        Assertions.assertEquals((long)100L, (long)longValue.getValue());
        longValue.setMaxValue(50L);
        Assertions.assertEquals((long)100L, (long)longValue.getValue());
    }

    @Test
    void testSetMinValue() {
        LongValueImpl longValue = new LongValueImpl();
        longValue.setValue(50L);
        longValue.setMinValue(25L);
        Assertions.assertEquals((long)25L, (long)longValue.getValue());
        longValue.setMinValue(50L);
        Assertions.assertEquals((long)25L, (long)longValue.getValue());
    }

    @Test
    void testGetAndSetVolatileValue() {
        LongValueImpl longValue = new LongValueImpl();
        longValue.setVolatileValue(123L);
        Assertions.assertEquals((long)123L, (long)longValue.getVolatileValue());
    }

    @Test
    void testSetOrderedValue() {
        LongValueImpl longValue = new LongValueImpl();
        longValue.setOrderedValue(456L);
        Assertions.assertEquals((long)456L, (long)longValue.getValue());
    }

    @Test
    void testAddAtomicValue() {
        LongValueImpl longValue = new LongValueImpl();
        longValue.setValue(10L);
        longValue.addAtomicValue(5L);
        Assertions.assertEquals((long)15L, (long)longValue.getValue());
        longValue.addAtomicValue(-3L);
        Assertions.assertEquals((long)12L, (long)longValue.getValue());
    }

    @Test
    void testIsClosed() {
        LongValueImpl longValue = new LongValueImpl();
        Assertions.assertFalse((boolean)longValue.isClosed());
        longValue.close();
        Assertions.assertTrue((boolean)longValue.isClosed());
    }

    @Test
    void testGetVolatileValue() {
        LongValueImpl longValue = new LongValueImpl();
        longValue.setValue(10L);
        Assertions.assertEquals((long)10L, (long)longValue.getVolatileValue());
    }

    @Test
    void testGetVolatileValueWithClosedValue() {
        LongValueImpl longValue = new LongValueImpl();
        longValue.setValue(10L);
        Assertions.assertEquals((long)10L, (long)longValue.getVolatileValue(20L));
        longValue.close();
        Assertions.assertEquals((long)20L, (long)longValue.getVolatileValue(20L));
    }
}

