/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Random;
import net.openhft.chronicle.core.CoreTestCommon;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.UnsafeMemory;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class UnsafeMemory2Test
extends CoreTestCommon {
    private static final int INT_VAL = 305419896;
    private final UnsafeMemory memory;

    public UnsafeMemory2Test(UnsafeMemory memory) {
        Assume.assumeFalse((Jvm.isArm() && !(memory instanceof UnsafeMemory.ARMMemory) ? 1 : 0) != 0);
        this.memory = memory;
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        UnsafeMemory memory1 = new UnsafeMemory();
        UnsafeMemory.ARMMemory memory2 = new UnsafeMemory.ARMMemory();
        Object[][] all = new Object[][]{{memory1}, {memory2}};
        Object[][] arm = new Object[][]{{memory2}};
        return Arrays.asList(Jvm.isArm() ? arm : all);
    }

    @Test
    public void stopBitLengthInt() {
        Assert.assertEquals((long)1L, (long)this.memory.stopBitLength(0));
        Assert.assertEquals((long)2L, (long)this.memory.stopBitLength(-1));
        for (int i = 7; i < 32; i += 7) {
            int j = 1 << i;
            Assert.assertEquals((long)(i / 7), (long)this.memory.stopBitLength(j - 1));
            Assert.assertEquals((long)(i / 7 + 1), (long)this.memory.stopBitLength(j));
            Assert.assertEquals((long)(i / 7 + 1), (long)this.memory.stopBitLength(-j));
            Assert.assertEquals((long)(i / 7 + 2), (long)this.memory.stopBitLength(~j));
        }
    }

    @Test
    public void stopBitLengthLong() {
        Assert.assertEquals((long)1L, (long)this.memory.stopBitLength(0L));
        Assert.assertEquals((long)2L, (long)this.memory.stopBitLength(-1L));
        for (int i = 7; i < 64; i += 7) {
            long j = 1L << i;
            Assert.assertEquals((long)(i / 7), (long)this.memory.stopBitLength(j - 1L));
            Assert.assertEquals((long)(i / 7 + 1), (long)this.memory.stopBitLength(j));
            Assert.assertEquals((long)(i / 7 + 1), (long)this.memory.stopBitLength(-j));
            if (i >= 63) continue;
            Assert.assertEquals((long)(i / 7 + 2), (long)this.memory.stopBitLength(j ^ 0xFFFFFFFFFFFFFFFFL));
        }
    }

    @Test
    public void is7BitBytes() {
        for (int i = 0; i <= 64; ++i) {
            byte[] bytes = new byte[i];
            Assert.assertTrue((boolean)this.memory.is7Bit(bytes, 0, i));
            if (i == 0) continue;
            bytes[i - 1] = -1;
            Assert.assertFalse((boolean)this.memory.is7Bit(bytes, 0, i));
        }
    }

    @Test
    public void is7BitBytes2() {
        byte[] bytes = new byte[256];
        for (int i = 0; i < 256; ++i) {
            bytes[i] = (byte)i;
        }
        Random rand = new Random();
        for (int i = 0; i < 1000; ++i) {
            int a = rand.nextInt(256);
            int b = rand.nextInt(256);
            int start = Math.min(a, b);
            int length = Math.abs(a - b);
            if (length == 0) {
                Assert.assertTrue((boolean)this.memory.is7Bit(bytes, start, length));
                continue;
            }
            Assert.assertEquals((String)("start: " + start + ", length: " + length), (Object)(start + length <= 128 ? 1 : 0), (Object)this.memory.is7Bit(bytes, start, length));
        }
    }

    @Test
    public void is7BitChars() {
        for (int i = 0; i <= 64; ++i) {
            char[] chars = new char[i];
            Assert.assertTrue((boolean)this.memory.is7Bit(chars, 0, i));
            if (i == 0) continue;
            chars[i - 1] = 32768;
            Assert.assertFalse((boolean)this.memory.is7Bit(chars, 0, i));
        }
    }

    @Test
    public void is7BitChars2() {
        char[] chars = new char[512];
        for (int i = 0; i < 512; ++i) {
            chars[i] = (char)i;
        }
        Random rand = new Random();
        for (int i = 0; i < 1000; ++i) {
            int a = rand.nextInt(512);
            int b = rand.nextInt(512);
            int start = Math.min(a, b);
            int length = Math.abs(a - b);
            if (length == 0) {
                Assert.assertTrue((boolean)this.memory.is7Bit(chars, start, length));
                continue;
            }
            Assert.assertEquals((String)("start: " + start + ", length: " + length), (Object)(start + length <= 128 ? 1 : 0), (Object)this.memory.is7Bit(chars, start, length));
        }
    }

    @Test
    public void is7BitAddr() {
        long addr = UnsafeMemory.UNSAFE.allocateMemory(64L);
        Assert.assertTrue((boolean)this.memory.is7Bit(addr, 0));
        for (int i = 1; i <= 64; ++i) {
            this.memory.writeByte(addr + (long)i - 1L, (byte)-1);
            Assert.assertFalse((boolean)this.memory.is7Bit(addr, i));
            this.memory.writeByte(addr + (long)i - 1L, (byte)0);
        }
        UnsafeMemory.UNSAFE.freeMemory(addr);
    }

    @Test
    public void is7BitAddr2() {
        long addr = UnsafeMemory.UNSAFE.allocateMemory(256L);
        for (int i = 0; i < 256; ++i) {
            this.memory.writeByte(addr + (long)i, (byte)i);
        }
        Random rand = new Random();
        for (int i = 0; i < 1000; ++i) {
            int a = rand.nextInt(256);
            int b = rand.nextInt(256);
            int start = Math.min(a, b);
            int length = Math.abs(a - b);
            if (length == 0) {
                Assert.assertTrue((boolean)this.memory.is7Bit(addr + (long)start, length));
                continue;
            }
            Assert.assertEquals((String)("start: " + start + ", length: " + length), (Object)(start + length <= 128 ? 1 : 0), (Object)this.memory.is7Bit(addr + (long)start, length));
        }
        UnsafeMemory.UNSAFE.freeMemory(addr);
    }

    @Test
    public void partialReadBytes() {
        byte[] bytes = new byte[16];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)(16 + i);
        }
        String s8 = Long.toHexString(this.memory.partialRead(bytes, 0, 8));
        for (int i = 1; i < 8; ++i) {
            String s = Long.toHexString(this.memory.partialRead(bytes, 0, i));
            Assert.assertEquals((Object)s8.substring(16 - i * 2), (Object)s);
        }
    }

    @Test
    public void partialWriteBytes() {
        byte[] bytes = new byte[16];
        for (int i = 0; i < 8; ++i) {
            long value = 1157726452361532951L;
            this.memory.partialWrite(bytes, 0, 1157726452361532951L, i);
            long l = this.memory.partialRead(bytes, 0, 8);
            long mask = (1L << 8 * i) - 1L;
            Assert.assertEquals((String)("i: " + i), (Object)Long.toHexString(0x1011121314151617L & mask), (Object)Long.toHexString(l));
        }
    }

    @Test
    public void partialReadAddr() {
        long addr = this.memory.allocate(16L);
        for (int i = 0; i < 16; ++i) {
            this.memory.writeByte(addr + (long)i, (byte)(16 + i));
        }
        String s8 = Long.toHexString(this.memory.partialRead(addr, 8));
        for (int i = 1; i < 8; ++i) {
            String s = Long.toHexString(this.memory.partialRead(addr, i));
            Assert.assertEquals((Object)s8.substring(16 - i * 2), (Object)s);
        }
        this.memory.freeMemory(addr, 16L);
    }

    @Test
    public void partialWriteAddr() {
        long addr = this.memory.allocate(16L);
        this.memory.partialWrite(addr, 0L, 8);
        for (int i = 0; i < 8; ++i) {
            long value = 1157726452361532951L;
            this.memory.partialWrite(addr, 1157726452361532951L, i);
            long l = this.memory.partialRead(addr, 8);
            long mask = (1L << 8 * i) - 1L;
            Assert.assertEquals((String)("i: " + i), (Object)Long.toHexString(0x1011121314151617L & mask), (Object)Long.toHexString(l));
        }
        this.memory.freeMemory(addr, 16L);
    }

    @Test
    public void copyMemory() {
        int capacity = 37;
        long addr = this.memory.allocate(37L);
        long addr2 = this.memory.allocate(37L);
        int b1 = 127;
        int b2 = -128;
        this.memory.setMemory(addr2, 37L, (byte)127);
        for (int i = 1; i < 36; ++i) {
            for (int j = i + 1; j < 36; ++j) {
                this.memory.setMemory(addr, 37L, (byte)-128);
                UnsafeMemory.copyMemory((long)addr2, (long)(addr + (long)i), (int)(j - i));
                Assert.assertEquals((long)-128L, (long)this.memory.readByte(addr + (long)i - 1L));
                Assert.assertEquals((long)127L, (long)this.memory.readByte(addr + (long)i));
                Assert.assertEquals((long)127L, (long)this.memory.readByte(addr + (long)j - 1L));
                Assert.assertEquals((long)-128L, (long)this.memory.readByte(addr + (long)j));
            }
        }
        this.memory.freeMemory(addr, 37L);
        this.memory.freeMemory(addr2, 37L);
    }

    @Test
    public void copyMemoryMoreThanThreshold() {
        long capacity = 0x280000L;
        long addr = this.memory.allocate(0x280000L);
        long addr2 = this.memory.allocate(0x280000L);
        int i = 0;
        while ((long)i < 0x280000L) {
            this.memory.writeInt(addr + (long)i, i);
            i += 4;
        }
        int b2 = -128;
        this.memory.setMemory(addr2, 0x280000L, (byte)-128);
        this.memory.copyMemory(addr, addr2, 0x280000L);
        int i2 = 0;
        while ((long)i2 < 0x280000L) {
            Assert.assertEquals((long)i2, (long)this.memory.readInt(addr2 + (long)i2));
            i2 += 4;
        }
        this.memory.freeMemory(addr, 0x280000L);
        this.memory.freeMemory(addr2, 0x280000L);
    }

    @Test
    public void address() {
        Assert.assertNotEquals((long)0L, (long)this.memory.address(ByteBuffer.allocateDirect(32)));
    }

    @Test
    public void setMemory() {
        long[] ds = new long[2];
        this.memory.setMemory((Object)ds, (long)this.memory.arrayBaseOffset(long[].class), 16L, (byte)1);
        Assert.assertEquals((long)0x101010101010101L, (long)ds[0]);
        Assert.assertEquals((long)0x101010101010101L, (long)ds[1]);
    }

    @Test
    public void copyMemoryEachWayLongArrayMemory() {
        long[] data = new long[]{1L, 2L, 3L, 4L};
        int lengthInBytes = data.length * 8;
        long addr = this.memory.allocate((long)lengthInBytes);
        this.memory.copyMemory((Object)data, (long)this.memory.arrayBaseOffset(data.getClass()), addr, lengthInBytes);
        long[] check = new long[data.length];
        this.memory.copyMemory(addr, (Object)check, (long)this.memory.arrayBaseOffset(data.getClass()), lengthInBytes);
        Assert.assertArrayEquals((long[])data, (long[])check);
    }

    @Test
    public void copyMemoryEachWayByteArrayMemory() {
        int capacity = 37;
        byte[] data = new byte[capacity];
        for (int i = 0; i < capacity; ++i) {
            data[i] = (byte)i;
        }
        long addr = this.memory.allocate((long)capacity);
        this.memory.copyMemory(data, 0, addr, capacity);
        byte[] check = new byte[data.length];
        this.memory.copyMemory(addr, (Object)check, (long)this.memory.arrayBaseOffset(data.getClass()), capacity);
        Assert.assertArrayEquals((byte[])data, (byte[])check);
    }

    @Test
    public void copyMemoryByteArray() {
        int capacity = 37;
        byte[] data = new byte[capacity];
        for (int i = 0; i < capacity; ++i) {
            data[i] = (byte)i;
        }
        byte[] dest = new byte[capacity];
        this.memory.copyMemory(data, 0, dest, 0, capacity);
        Assert.assertArrayEquals((byte[])data, (byte[])dest);
    }

    @Test
    public void copyMemoryByteArrayAsObject() {
        int capacity = 37;
        byte[] data = new byte[capacity];
        for (int i = 0; i < capacity; ++i) {
            data[i] = (byte)i;
        }
        byte[] dest = new byte[capacity];
        this.memory.copyMemory((Object)data, (long)this.memory.arrayBaseOffset(data.getClass()), (Object)dest, (long)this.memory.arrayBaseOffset(data.getClass()), capacity);
        Assert.assertArrayEquals((byte[])data, (byte[])dest);
    }

    @Test
    public void copyMemoryEachWayByteArrayLongArray() {
        long[] longs = new long[]{506097522914230528L, 1084818905618843912L};
        long[] copy = new long[longs.length];
        System.arraycopy(longs, 0, copy, 0, longs.length);
        int lengthInBytes = longs.length * 8;
        byte[] bytes = new byte[lengthInBytes];
        this.memory.copyMemory((Object)longs, (long)this.memory.arrayBaseOffset(longs.getClass()), (Object)bytes, (long)this.memory.arrayBaseOffset(bytes.getClass()), lengthInBytes);
        for (int i = 0; i < lengthInBytes; ++i) {
            Assert.assertEquals((long)i, (long)bytes[i]);
        }
        Arrays.fill(longs, 0L);
        this.memory.copyMemory((Object)bytes, 0L, (Object)longs, (long)this.memory.arrayBaseOffset(longs.getClass()), lengthInBytes);
        Assert.assertArrayEquals((long[])copy, (long[])longs);
    }

    @Test
    public void copyMemoryOverlap() {
        int i;
        int capacity = 32;
        byte[] data = new byte[capacity];
        for (int i2 = 0; i2 < capacity; ++i2) {
            data[i2] = (byte)i2;
        }
        int offset = capacity / 4;
        int length = capacity / 4 * 3;
        this.memory.copyMemory(data, 0, data, offset, length);
        for (i = 0; i < offset; ++i) {
            Assert.assertEquals((long)i, (long)data[i]);
        }
        for (i = 0; i < length; ++i) {
            Assert.assertEquals((long)i, (long)data[i + offset]);
        }
    }

    @Test
    public void copyMemoryOverlapBackwards() {
        int i;
        int capacity = 32;
        byte[] data = new byte[capacity];
        for (int i2 = 0; i2 < capacity; ++i2) {
            data[i2] = (byte)i2;
        }
        int offset = capacity / 4;
        int length = capacity / 4 * 3;
        this.memory.copyMemory(data, offset, data, 0, length);
        for (i = 0; i < length; ++i) {
            Assert.assertEquals((long)(i + offset), (long)data[i]);
        }
        for (i = length; i < capacity; ++i) {
            Assert.assertEquals((long)i, (long)data[i]);
        }
    }

    @Test
    public void copyMemoryHeapObject() throws NoSuchFieldException {
        Field num = MyDTO.class.getDeclaredField("num");
        long offset = this.memory.objectFieldOffset(num);
        MyDTO from = new MyDTO();
        from.num = 99;
        MyDTO to = new MyDTO();
        this.memory.copyMemory((Object)from, offset, (Object)to, offset, 4);
        Assert.assertEquals((long)from.num, (long)to.num);
    }

    @Test
    public void copyMemoryEachWayByteArrayHeapObject() throws NoSuchFieldException {
        Field num = MyDTO.class.getDeclaredField("num");
        long offset = this.memory.objectFieldOffset(num);
        byte[] data = new byte[4];
        data[0] = 98;
        MyDTO to = new MyDTO();
        this.memory.copyMemory(data, 0, (Object)to, offset, 4);
        Assert.assertEquals((long)data[0], (long)to.num);
        to.num = 77;
        this.memory.copyMemory((Object)to, offset, (Object)data, (long)this.memory.arrayBaseOffset(data.getClass()), 4);
        Assert.assertEquals((long)to.num, (long)data[0]);
    }

    @Test
    public void copyMemoryEachWayAddressHeapObject() throws NoSuchFieldException {
        Field num = MyDTO.class.getDeclaredField("num");
        long offset = this.memory.objectFieldOffset(num);
        long addr = this.memory.allocate(4L);
        int expected = 97;
        UnsafeMemory.unsafePutInt((long)addr, (int)expected);
        MyDTO to = new MyDTO();
        this.memory.copyMemory(addr, (Object)to, offset, 4);
        Assert.assertEquals((long)expected, (long)to.num);
        to.num = 75;
        this.memory.copyMemory((Object)to, offset, addr, 4);
        Assert.assertEquals((long)to.num, (long)UnsafeMemory.unsafeGetInt((long)addr));
    }

    @Test
    public void safeAlignTest() {
        for (int i = -1; i < 70; ++i) {
            if (this.memory instanceof UnsafeMemory.ARMMemory) {
                Assert.assertEquals((Object)(i % 4 == 0 ? 1 : 0), (Object)this.memory.safeAlignedInt((long)i));
                continue;
            }
            Assert.assertEquals((Object)((i & 0x3F) + 4 <= 64 ? 1 : 0), (Object)this.memory.safeAlignedInt((long)i));
        }
    }

    @Test
    public void arrayBaseOffset() {
        Assert.assertEquals((float)12.0f, (float)this.memory.arrayBaseOffset(byte[].class), (float)4.0f);
    }

    @Test
    public void objectFieldOffset() throws NoSuchFieldException {
        Field num = MyDTO.class.getDeclaredField("num");
        Assert.assertEquals((float)12.0f, (float)this.memory.objectFieldOffset(num), (float)4.0f);
    }

    @Test
    public void directMemoryByte() {
        long memory = this.memory.allocate(32L);
        this.memory.writeByte(null, memory, (byte)12);
        Assert.assertEquals((long)12L, (long)this.memory.readByte(null, memory));
        this.memory.freeMemory(memory, 32L);
    }

    @Test
    public void directMemoryShort() {
        long memory = this.memory.allocate(32L);
        this.memory.writeShort(null, memory, (short)12345);
        Assert.assertEquals((long)12345L, (long)this.memory.readShort(null, memory));
        this.memory.freeMemory(memory, 32L);
    }

    @Test
    public void directMemoryInt() {
        long memory = this.memory.allocate(32L);
        this.memory.writeInt(null, memory, 305419896);
        Assert.assertEquals((long)305419896L, (long)this.memory.readInt(null, memory));
        this.memory.freeMemory(memory, 32L);
    }

    @Test
    public void directMemoryAddInt() {
        long memory = this.memory.allocate(32L);
        this.memory.writeInt(memory, 0);
        int actual = this.memory.addInt(null, memory, 305419896);
        Assert.assertEquals((long)305419896L, (long)actual);
        Assert.assertEquals((long)305419896L, (long)this.memory.readInt(memory));
        this.memory.freeMemory(memory, 32L);
    }

    @Test
    public void directMemoryCASInt() {
        long memory = this.memory.allocate(32L);
        this.memory.writeInt(memory, 0);
        boolean actual = this.memory.compareAndSwapInt(null, memory, 0, 305419896);
        Assert.assertTrue((boolean)actual);
        Assert.assertEquals((long)305419896L, (long)this.memory.readInt(memory));
        this.memory.freeMemory(memory, 32L);
    }

    @Test
    public void directMemoryLong() {
        long memory = this.memory.allocate(32L);
        this.memory.writeLong(null, memory, Long.MAX_VALUE);
        Assert.assertEquals((long)Long.MAX_VALUE, (long)this.memory.readLong(null, memory));
        this.memory.freeMemory(memory, 32L);
    }

    @Test
    public void directMemoryAddLong() {
        long memory = this.memory.allocate(32L);
        this.memory.writeLong(memory, 0L);
        long actual = this.memory.addLong(null, memory, Long.MAX_VALUE);
        Assert.assertEquals((long)Long.MAX_VALUE, (long)actual);
        Assert.assertEquals((long)Long.MAX_VALUE, (long)this.memory.readLong(memory));
        this.memory.freeMemory(memory, 32L);
    }

    @Test
    public void directMemoryCASLong() {
        long memory = this.memory.allocate(32L);
        this.memory.writeLong(memory, 0L);
        boolean actual = this.memory.compareAndSwapLong(null, memory, 0L, Long.MAX_VALUE);
        Assert.assertTrue((boolean)actual);
        Assert.assertEquals((long)Long.MAX_VALUE, (long)this.memory.readLong(memory));
        this.memory.freeMemory(memory, 32L);
    }

    @Test
    public void directMemoryFloat() {
        long memory = this.memory.allocate(32L);
        this.memory.writeFloat(null, memory, 1.2345f);
        Assert.assertEquals((float)1.2345f, (float)this.memory.readFloat(null, memory), (float)0.0f);
        this.memory.freeMemory(memory, 32L);
    }

    @Test
    public void directMemoryDouble() {
        long memory = this.memory.allocate(32L);
        this.memory.writeDouble(null, memory, 1.2345);
        Assert.assertEquals((double)1.2345, (double)this.memory.readDouble(null, memory), (double)0.0);
        this.memory.freeMemory(memory, 32L);
    }

    @Test(expected=Exception.class)
    public void directMemoryReference1() {
        long memory = this.memory.allocate(32L);
        try {
            this.memory.putObject(null, memory, (Object)1.2345);
        }
        finally {
            this.memory.freeMemory(memory, 32L);
        }
        Assert.assertEquals((double)1.2345, (double)((Double)this.memory.getObject(null, memory)), (double)0.0);
    }

    @Test(expected=Exception.class)
    public void directMemoryReference2() {
        long memory = this.memory.allocate(32L);
        try {
            this.memory.getObject(null, memory);
            Assert.fail();
        }
        finally {
            this.memory.freeMemory(memory, 32L);
        }
    }

    @Test
    public void directMemoryVolatileByte() {
        long memory = this.memory.allocate(32L);
        this.memory.writeVolatileByte(null, memory, (byte)12);
        Assert.assertEquals((long)12L, (long)this.memory.readVolatileByte(null, memory));
        this.memory.freeMemory(memory, 32L);
    }

    @Test
    public void directMemoryVolatileShort() {
        long memory = this.memory.allocate(32L);
        this.memory.writeVolatileShort(null, memory, (short)12345);
        Assert.assertEquals((long)12345L, (long)this.memory.readVolatileShort(null, memory));
        this.memory.freeMemory(memory, 32L);
    }

    @Test
    public void directMemoryVolatileInt() {
        long memory = this.memory.allocate(32L);
        this.memory.writeVolatileInt(null, memory, 305419896);
        Assert.assertEquals((long)305419896L, (long)this.memory.readVolatileInt(null, memory));
        this.memory.freeMemory(memory, 32L);
    }

    @Test
    public void directMemoryOrderedInt() {
        long memory = this.memory.allocate(32L);
        this.memory.writeOrderedInt(null, memory, 305419896);
        Assert.assertEquals((long)305419896L, (long)this.memory.readVolatileInt(null, memory));
        this.memory.freeMemory(memory, 32L);
    }

    @Test
    public void directMemoryVolatileLong() {
        long memory = this.memory.allocate(32L);
        this.memory.writeVolatileLong(null, memory, Long.MAX_VALUE);
        Assert.assertEquals((long)Long.MAX_VALUE, (long)this.memory.readVolatileLong(null, memory));
        this.memory.freeMemory(memory, 32L);
    }

    @Test
    public void directMemoryOrderedLong() {
        long memory = this.memory.allocate(32L);
        this.memory.writeOrderedLong(null, memory, Long.MAX_VALUE);
        Assert.assertEquals((long)Long.MAX_VALUE, (long)this.memory.readVolatileLong(null, memory));
        this.memory.freeMemory(memory, 32L);
    }

    @Test
    public void directMemoryVolatileFloat() {
        long memory = this.memory.allocate(32L);
        this.memory.writeVolatileFloat(null, memory, 1.2345f);
        Assert.assertEquals((float)1.2345f, (float)this.memory.readVolatileFloat(null, memory), (float)0.0f);
        this.memory.freeMemory(memory, 32L);
    }

    @Test
    public void directMemoryVolatileDouble() {
        long memory = this.memory.allocate(32L);
        this.memory.writeVolatileDouble(null, memory, 1.2345);
        Assert.assertEquals((double)1.2345, (double)this.memory.readVolatileDouble(null, memory), (double)0.0);
        this.memory.freeMemory(memory, 32L);
    }

    static class MyDTO {
        int num;

        MyDTO() {
        }
    }
}

