/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.cooler;

import java.util.concurrent.Callable;
import net.openhft.chronicle.core.cooler.CoolerTester;
import net.openhft.chronicle.core.cooler.CpuCooler;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class CoolerTesterTest {
    CoolerTesterTest() {
    }

    @Test
    void shouldExecuteCallableWithEachCooler() throws Exception {
        Callable mockTask = (Callable)Mockito.mock(Callable.class);
        CpuCooler mockCooler = (CpuCooler)Mockito.mock(CpuCooler.class);
        CoolerTester tester = new CoolerTester(mockCooler, new Callable[]{mockTask});
        tester.repeat(1).minCount(1).maxCount(1);
        tester.run();
        ((Callable)Mockito.verify((Object)mockTask, (VerificationMode)Mockito.atLeastOnce())).call();
        ((CpuCooler)Mockito.verify((Object)mockCooler, (VerificationMode)Mockito.atLeastOnce())).disturb();
    }

    @Test
    void constructorShouldInitializeWithGivenParameters() throws Exception {
        Callable mockTask = (Callable)Mockito.mock(Callable.class);
        CpuCooler mockCooler1 = (CpuCooler)Mockito.mock(CpuCooler.class);
        CpuCooler mockCooler2 = (CpuCooler)Mockito.mock(CpuCooler.class);
        CoolerTester tester = new CoolerTester(mockTask, new CpuCooler[]{mockCooler1, mockCooler2});
    }

    @Test
    void getterMethodsShouldReturnCorrectValues() {
        CoolerTester tester = new CoolerTester(new CpuCooler[0]);
        tester.repeat(5).runTimeMS(1000).minCount(10).maxCount(100);
        Assert.assertEquals((long)5L, (long)tester.repeat());
        Assert.assertEquals((long)1000L, (long)tester.runTimeMS());
        Assert.assertEquals((long)10L, (long)tester.minCount());
        Assert.assertEquals((long)100L, (long)tester.maxCount());
    }

    @Test
    void shouldRecordExecutionTimesInHistograms() throws Exception {
    }

    @Test
    void configurationMethodsShouldAffectExecution() {
    }

    @Test
    void runMethodShouldExecuteWithoutErrors() {
        Callable mockTask = (Callable)Mockito.mock(Callable.class);
        CpuCooler mockCooler = (CpuCooler)Mockito.mock(CpuCooler.class);
        CoolerTester tester = new CoolerTester(mockCooler, new Callable[]{mockTask});
        Assertions.assertDoesNotThrow(() -> ((CoolerTester)tester).run());
    }
}

