/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.internal;

import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.internal.Bootstrap;
import net.openhft.chronicle.core.internal.CpuClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class CpuClassTest {
    @Test
    public void getCpuModel() {
        String cpuClass = CpuClass.getCpuModel();
        System.out.println("cpuClass: " + cpuClass + ", os.name: " + System.getProperty("os.name") + ", os.arch: " + System.getProperty("os.arch"));
        if (Jvm.isMacArm()) {
            Assert.assertTrue((String)cpuClass, (boolean)cpuClass.startsWith("Apple M"));
        } else if (Jvm.isArm()) {
            Assert.assertTrue((String)cpuClass, (boolean)cpuClass.startsWith("ARMv"));
        } else {
            Assert.assertTrue((String)cpuClass, (cpuClass.contains("Intel") || cpuClass.startsWith("AMD ") ? 1 : 0) != 0);
        }
        Assert.assertNotNull((Object)cpuClass);
    }

    @Test
    public void removingTag() {
        Assume.assumeFalse((boolean)Bootstrap.IS_MAC);
        String actual = (String)CpuClass.removingTag().apply("tag: value");
        Assert.assertEquals((Object)"value", (Object)actual);
    }

    @Test
    public void getCpuModelShouldReturnNonNullValue() {
        Assert.assertNotNull((String)CpuClass.getCpuModel(), (Object)"CPU model should not be null");
    }

    @Test
    public void getCpuModelShouldReturnNonEmptyValue() {
        Assert.assertNotEquals((String)"", (Object)CpuClass.getCpuModel(), (Object)"CPU model should not be an empty string");
    }
}

