/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.internal;

import net.openhft.chronicle.core.internal.ReferenceCountedUtils;
import net.openhft.chronicle.core.io.AbstractReferenceCounted;
import net.openhft.chronicle.core.io.ReferenceCounted;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class ReferenceCountedUtilsTest {
    @BeforeEach
    public void setUp() {
        ReferenceCountedUtils.enableReferenceTracing();
    }

    @AfterEach
    public void tearDown() {
        ReferenceCountedUtils.disableReferenceTracing();
    }

    @Test
    public void unmonitorShouldRemoveReference() {
        AbstractReferenceCounted referenceCounted = (AbstractReferenceCounted)Mockito.mock(AbstractReferenceCounted.class);
        Mockito.when((Object)referenceCounted.refCount()).thenReturn((Object)1);
        ReferenceCountedUtils.add((AbstractReferenceCounted)referenceCounted);
        ReferenceCountedUtils.unmonitor((ReferenceCounted)referenceCounted);
        Assertions.assertDoesNotThrow(ReferenceCountedUtils::assertReferencesReleased, (String)"Unmonitored references should not be checked");
    }
}

