/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.internal.util;

import java.nio.ByteBuffer;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.internal.util.DirectBufferUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import sun.nio.ch.DirectBuffer;

public class DirectBufferUtilTest {
    @Test
    public void directBufferClassShouldReturnCorrectClass() {
        Assertions.assertEquals(DirectBuffer.class, (Object)DirectBufferUtil.directBufferClass(), (String)"DirectBuffer class should be returned");
    }

    @Test
    public void cleanIfInstanceOfDirectBufferShouldCleanDirectBuffer() {
        Assumptions.assumeFalse((boolean)Jvm.isJava9Plus());
        ByteBuffer directBuffer = ByteBuffer.allocateDirect(1024);
        Assertions.assertDoesNotThrow(() -> DirectBufferUtil.cleanIfInstanceOfDirectBuffer((ByteBuffer)directBuffer), (String)"Cleaning a direct buffer should not throw an exception");
    }

    @Test
    public void cleanIfInstanceOfDirectBufferShouldNotThrowForNonDirectBuffer() {
        ByteBuffer nonDirectBuffer = ByteBuffer.allocate(1024);
        Assertions.assertDoesNotThrow(() -> DirectBufferUtil.cleanIfInstanceOfDirectBuffer((ByteBuffer)nonDirectBuffer), (String)"Non-direct buffer should not throw an exception");
    }

    @Test
    public void addressOrThrowShouldReturnAddressForDirectBuffer() {
        ByteBuffer directBuffer = ByteBuffer.allocateDirect(1024);
        Assertions.assertDoesNotThrow(() -> DirectBufferUtil.addressOrThrow((ByteBuffer)directBuffer), (String)"Getting address of a direct buffer should not throw an exception");
    }

    @Test
    public void addressOrThrowShouldThrowForNonDirectBuffer() {
        ByteBuffer nonDirectBuffer = ByteBuffer.allocate(1024);
        Assertions.assertThrows(ClassCastException.class, () -> DirectBufferUtil.addressOrThrow((ByteBuffer)nonDirectBuffer), (String)"Non-direct buffer should throw ClassCastException");
    }
}

