/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.io;

import java.util.Map;
import java.util.stream.Collectors;
import net.openhft.chronicle.core.CoreTestCommon;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.AbstractCloseable;
import org.junit.Assert;
import org.junit.Test;

public class AbstractCloseableTest
extends CoreTestCommon {
    @Test
    public void close() throws IllegalStateException {
        MyCloseable mc = new MyCloseable();
        Assert.assertFalse((boolean)mc.isClosed());
        Assert.assertEquals((long)0L, (long)mc.performClose);
        mc.throwExceptionIfClosed();
        mc.close();
        Assert.assertTrue((boolean)mc.isClosed());
        Assert.assertEquals((long)1L, (long)mc.performClose);
        mc.close();
        Assert.assertTrue((boolean)mc.isClosed());
        Assert.assertEquals((long)1L, (long)mc.performClose);
    }

    @Test(expected=IllegalStateException.class)
    public void throwExceptionIfClosed() throws IllegalStateException {
        MyCloseable mc = new MyCloseable();
        mc.close();
        mc.throwExceptionIfClosed();
    }

    @Test
    public void warnAndCloseIfNotClosed() {
        Jvm.setResourceTracing((boolean)true);
        Map map = Jvm.recordExceptions();
        MyCloseable mc = new MyCloseable();
        System.err.println("!!! The following warning is expected !!!");
        mc.warnAndCloseIfNotClosed();
        Assert.assertTrue((boolean)mc.isClosed());
        Jvm.resetExceptionHandlers();
        if (!AbstractCloseable.DISABLE_DISCARD_WARNING) {
            Assert.assertEquals((Object)"Discarded without closing\njava.lang.IllegalStateException: net.openhft.chronicle.core.StackTrace: net.openhft.chronicle.core.io.AbstractCloseableTest$MyCloseable created here on main", (Object)map.keySet().stream().map(e -> e.message() + "\n" + e.throwable()).collect(Collectors.joining(", ")));
        }
    }

    @Test
    public void assertCloseable() {
        MyCloseable myCloseable = new MyCloseable(){
            int cnt = 0;

            protected void assertCloseable() {
                if (this.cnt++ == 0) {
                    throw new IllegalStateException("First close will always fail!");
                }
            }
        };
        try {
            myCloseable.close();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)myCloseable.performClose);
        myCloseable.close();
        Assert.assertEquals((long)1L, (long)myCloseable.performClose);
    }

    static class MyCloseable
    extends AbstractCloseable {
        int performClose;

        MyCloseable() {
        }

        protected void performClose() {
            Assert.assertTrue((boolean)this.isClosing());
            Assert.assertFalse((boolean)this.isClosed());
            ++this.performClose;
        }
    }
}

