/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.io;

import net.openhft.chronicle.core.io.ClosedIllegalStateException;
import net.openhft.chronicle.core.io.ReferenceChangeListener;
import net.openhft.chronicle.core.io.ReferenceCountedContractTest;
import net.openhft.chronicle.core.io.ReferenceCountedTracer;
import net.openhft.chronicle.core.io.ReferenceOwner;
import org.junit.Assert;
import org.junit.Test;

public abstract class ReferenceCountedTracerContractTest
extends ReferenceCountedContractTest {
    protected abstract ReferenceCountedTracer createReferenceCounted();

    @Test
    public void throwIfReleasedWillThrowIfResourceIsReleased() {
        ReferenceCountedTracer referenceCounted = this.createReferenceCounted();
        referenceCounted.releaseLast();
        Assert.assertThrows(ClosedIllegalStateException.class, () -> ((ReferenceCountedTracer)referenceCounted).throwExceptionIfReleased());
    }

    @Test
    public void throwIfReleasedWillNotThrowIfResourceIsNotReleased() {
        ReferenceCountedTracer referenceCounted = this.createReferenceCounted();
        referenceCounted.throwExceptionIfReleased();
    }

    @Test
    public void throwIfNotReleasedWillThrowIfResourceIsNotReleased() {
        ReferenceCountedTracer referenceCounted = this.createReferenceCounted();
        Assert.assertThrows(IllegalStateException.class, () -> ((ReferenceCountedTracer)referenceCounted).throwExceptionIfNotReleased());
    }

    @Test
    public void throwIfNotReleasedWillNotThrowIfResourceIsReleased() {
        ReferenceCountedTracer referenceCounted = this.createReferenceCounted();
        referenceCounted.releaseLast();
        referenceCounted.throwExceptionIfNotReleased();
    }

    @Test
    public void listenersShouldNotBeNotifiedOnWarnAndReleaseIfNotReleased() {
        ReferenceCountedTracer rc = this.createReferenceCounted();
        ReferenceOwner a = ReferenceOwner.temporary((String)"a");
        ReferenceOwner b = ReferenceOwner.temporary((String)"b");
        ReferenceCountedContractTest.CounterReferenceChangeListener listener = new ReferenceCountedContractTest.CounterReferenceChangeListener();
        rc.addReferenceChangeListener((ReferenceChangeListener)listener);
        rc.reserve(a);
        rc.reserve(b);
        this.expectException("Discarded without being released");
        rc.warnAndReleaseIfNotReleased();
        Assert.assertEquals((long)0L, (long)listener.referenceRemovedCount);
    }
}

