/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.io;

import net.openhft.chronicle.core.io.Syncable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class SyncableTest {
    @Test
    public void syncIfAvailableShouldCallSyncOnSyncableObjects() {
        Syncable syncableMock = (Syncable)Mockito.mock(Syncable.class);
        Syncable.syncIfAvailable((Object)syncableMock);
        ((Syncable)Mockito.verify((Object)syncableMock, (VerificationMode)Mockito.times((int)1))).sync();
    }

    @Test
    public void syncIfAvailableShouldNotThrowExceptionForNonSyncableObjects() {
        Object nonSyncableObject = new Object();
        Assertions.assertDoesNotThrow(() -> Syncable.syncIfAvailable((Object)nonSyncableObject));
    }

    @Test
    public void syncShouldSetSyncedToTrueForSyncableImpl() {
        SyncableImpl syncableImpl = new SyncableImpl();
        Assertions.assertFalse((boolean)syncableImpl.synced);
        syncableImpl.sync();
        Assertions.assertTrue((boolean)syncableImpl.synced);
    }

    public static class SyncableImpl
    implements Syncable {
        boolean synced = false;

        public void sync() {
            this.synced = true;
        }
    }
}

