/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.io;

import net.openhft.chronicle.core.io.InvalidMarshallableException;
import net.openhft.chronicle.core.io.Validatable;
import net.openhft.chronicle.core.io.ValidatableUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ValidatableUtilTest {
    @Test
    public void testValidateToggle() {
        Assertions.assertTrue((boolean)ValidatableUtil.validateEnabled());
        ValidatableUtil.startValidateDisabled();
        Assertions.assertFalse((boolean)ValidatableUtil.validateEnabled());
        ValidatableUtil.endValidateDisabled();
        Assertions.assertTrue((boolean)ValidatableUtil.validateEnabled());
    }

    @Test
    public void testEndValidateDisabledWithoutStart() {
        AssertionError exception = (AssertionError)((Object)Assertions.assertThrows(AssertionError.class, ValidatableUtil::endValidateDisabled));
        Assertions.assertNotNull((Object)exception);
    }

    @Test
    public void testValidate() throws InvalidMarshallableException {
        Validatable validatable = (Validatable)Mockito.mock(Validatable.class);
        ValidatableUtil.validate((Object)validatable);
        ((Validatable)Mockito.verify((Object)validatable, (VerificationMode)Mockito.times((int)1))).validate();
    }
}

