/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.onoes;

import net.openhft.chronicle.core.CoreTestCommon;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.onoes.ExceptionHandler;
import net.openhft.chronicle.core.util.IgnoresEverything;
import net.openhft.chronicle.core.util.Mocker;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.slf4j.Logger;

public class ExceptionHandlerTest
extends CoreTestCommon {
    @Before
    public void mockitoNotSupportedOnJava21() {
        Assume.assumeTrue((Jvm.majorVersion() <= 17 ? 1 : 0) != 0);
    }

    @Test
    public void ignoresEverything() {
        Assert.assertTrue((boolean)(ExceptionHandler.ignoresEverything() instanceof IgnoresEverything));
    }

    @Test
    public void ignoresEverything2() {
        Assert.assertTrue((boolean)(Mocker.ignored(ExceptionHandler.class, (Class[])new Class[0]) instanceof IgnoresEverything));
    }

    @Test
    public void onWithClassAndThrowableShouldDelegateProperly() {
        ExceptionHandler handler = (ExceptionHandler)Mockito.mock(ExceptionHandler.class, (Answer)Mockito.CALLS_REAL_METHODS);
        Class<?> clazz = this.getClass();
        RuntimeException thrown = new RuntimeException();
        handler.on(clazz, (Throwable)thrown);
        ((ExceptionHandler)Mockito.verify((Object)handler)).on(clazz, "", (Throwable)thrown);
    }

    @Test
    public void onWithClassAndMessageShouldDelegateProperly() {
        ExceptionHandler handler = (ExceptionHandler)Mockito.mock(ExceptionHandler.class, (Answer)Mockito.CALLS_REAL_METHODS);
        Class<?> clazz = this.getClass();
        String message = "Test message";
        handler.on(clazz, message);
        ((ExceptionHandler)Mockito.verify((Object)handler)).on(clazz, message, null);
    }

    @Test
    public void onWithLoggerAndMessageShouldDelegateProperly() {
        ExceptionHandler handler = (ExceptionHandler)Mockito.mock(ExceptionHandler.class, (Answer)Mockito.CALLS_REAL_METHODS);
        Logger logger = (Logger)Mockito.mock(Logger.class);
        String message = "Test message";
        handler.on(logger, message);
        ((ExceptionHandler)Mockito.verify((Object)handler)).on(logger, message, null);
    }

    @Test
    public void isEnabledShouldAlwaysReturnTrue() {
        ExceptionHandler handler = (ExceptionHandler)Mockito.mock(ExceptionHandler.class, (Answer)Mockito.CALLS_REAL_METHODS);
        Assert.assertTrue((boolean)handler.isEnabled(this.getClass()));
    }

    @Test
    public void defaultHandlerShouldReturnSelf() {
        ExceptionHandler handler = (ExceptionHandler)Mockito.mock(ExceptionHandler.class, (Answer)Mockito.CALLS_REAL_METHODS);
        Assert.assertSame((Object)handler, (Object)handler.defaultHandler());
    }
}

