/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.pool;

import java.time.LocalDate;
import net.openhft.chronicle.core.CoreTestCommon;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.core.util.ClassNotFoundRuntimeException;
import org.junit.Assert;
import org.junit.Test;

public class ClassAliasPoolTest
extends CoreTestCommon {
    @Test
    public void testApplyAliasForSet() {
        Assert.assertEquals((Object)"!set", (Object)ClassAliasPool.CLASS_ALIASES.applyAlias((CharSequence)"Set").toString());
        Assert.assertEquals((Object)"!set", (Object)ClassAliasPool.CLASS_ALIASES.applyAlias((CharSequence)"java.util.Set").toString());
    }

    @Test
    public void testApplyAliasForBitSet() {
        Assert.assertEquals((Object)"!bitset", (Object)ClassAliasPool.CLASS_ALIASES.applyAlias((CharSequence)"BitSet").toString());
        Assert.assertEquals((Object)"!bitset", (Object)ClassAliasPool.CLASS_ALIASES.applyAlias((CharSequence)"java.util.BitSet").toString());
    }

    @Test
    public void testApplyAliasForSortedSet() {
        Assert.assertEquals((Object)"!oset", (Object)ClassAliasPool.CLASS_ALIASES.applyAlias((CharSequence)"SortedSet").toString());
        Assert.assertEquals((Object)"!oset", (Object)ClassAliasPool.CLASS_ALIASES.applyAlias((CharSequence)"java.util.SortedSet").toString());
    }

    @Test
    public void testApplyAliasForList() {
        Assert.assertEquals((Object)"!seq", (Object)ClassAliasPool.CLASS_ALIASES.applyAlias((CharSequence)"List").toString());
        Assert.assertEquals((Object)"!seq", (Object)ClassAliasPool.CLASS_ALIASES.applyAlias((CharSequence)"java.util.List").toString());
    }

    @Test
    public void testApplyAliasForMap() {
        Assert.assertEquals((Object)"!map", (Object)ClassAliasPool.CLASS_ALIASES.applyAlias((CharSequence)"Map").toString());
        Assert.assertEquals((Object)"!map", (Object)ClassAliasPool.CLASS_ALIASES.applyAlias((CharSequence)"java.util.Map").toString());
    }

    @Test
    public void testApplyAliasForSortedMap() {
        Assert.assertEquals((Object)"!omap", (Object)ClassAliasPool.CLASS_ALIASES.applyAlias((CharSequence)"SortedMap").toString());
        Assert.assertEquals((Object)"!omap", (Object)ClassAliasPool.CLASS_ALIASES.applyAlias((CharSequence)"java.util.SortedMap").toString());
    }

    @Test
    public void testApplyAliasForString() {
        Assert.assertEquals((Object)"String", (Object)ClassAliasPool.CLASS_ALIASES.applyAlias((CharSequence)"java.lang.String").toString());
    }

    @Test
    public void testApplyAliasForByte() {
        Assert.assertEquals((Object)"byte", (Object)ClassAliasPool.CLASS_ALIASES.applyAlias((CharSequence)"Byte").toString());
        Assert.assertEquals((Object)"byte", (Object)ClassAliasPool.CLASS_ALIASES.applyAlias((CharSequence)"java.lang.Byte").toString());
    }

    @Test
    public void testApplyAliasForInteger() {
        Assert.assertEquals((Object)"int", (Object)ClassAliasPool.CLASS_ALIASES.applyAlias((CharSequence)"Integer").toString());
        Assert.assertEquals((Object)"int", (Object)ClassAliasPool.CLASS_ALIASES.applyAlias((CharSequence)Integer.class.getName()).toString());
    }

    @Test
    public void testApplyAliasForLocalDate() {
        Assert.assertEquals((Object)"Date", (Object)ClassAliasPool.CLASS_ALIASES.applyAlias((CharSequence)"LocalDate").toString());
        Assert.assertEquals((Object)"Date", (Object)ClassAliasPool.CLASS_ALIASES.applyAlias((CharSequence)LocalDate.class.getName()).toString());
    }

    @Test
    public void forName() {
        ClassAliasPool.CLASS_ALIASES.addAlias(new Class[]{ClassAliasPoolTest.class});
        Assert.assertEquals((Object)"ClassAliasPoolTest", (Object)ClassAliasPool.CLASS_ALIASES.applyAlias((CharSequence)ClassAliasPoolTest.class.getName()));
        String simpleName = this.getClass().getSimpleName();
        Assert.assertEquals(ClassAliasPoolTest.class, (Object)ClassAliasPool.CLASS_ALIASES.forName((CharSequence)simpleName));
        StringBuilder sb = new StringBuilder(simpleName);
        Assert.assertEquals(ClassAliasPoolTest.class, (Object)ClassAliasPool.CLASS_ALIASES.forName((CharSequence)sb));
    }

    @Test
    public void testClean() throws IllegalArgumentException {
        Assert.assertEquals((Object)"String", (Object)ClassAliasPool.CLASS_ALIASES.nameFor(String.class));
        ClassAliasPool.CLASS_ALIASES.clean();
        Assert.assertEquals((Object)"String", (Object)ClassAliasPool.CLASS_ALIASES.nameFor(String.class));
    }

    @Test
    public void testEnum() throws IllegalArgumentException {
        Assert.assertEquals((Object)"net.openhft.chronicle.core.pool.ClassAliasPoolTest$TestEnum", (Object)ClassAliasPool.CLASS_ALIASES.nameFor(TestEnum.class));
        Assert.assertEquals((Object)"net.openhft.chronicle.core.pool.ClassAliasPoolTest$TestEnum", (Object)ClassAliasPool.CLASS_ALIASES.nameFor(((Object)((Object)TestEnum.FOO)).getClass()));
        Assert.assertEquals((Object)"net.openhft.chronicle.core.pool.ClassAliasPoolTest$TestEnum", (Object)ClassAliasPool.CLASS_ALIASES.nameFor(((Object)((Object)TestEnum.BAR)).getClass()));
    }

    @Test
    public void replace() {
        this.expectException("Replaced class net.openhft.chronicle.core.pool.ClassAliasPoolTest with class net.openhft.chronicle.core.pool.ClassAliasPoolTest$TestEnum");
        ClassAliasPool.CLASS_ALIASES.addAlias(ClassAliasPoolTest.class, "name1");
        ClassAliasPool.CLASS_ALIASES.addAlias(TestEnum.class, "name1");
    }

    @Test
    public void wrongCaseClassName() {
        Assert.assertThrows(ClassNotFoundRuntimeException.class, () -> ClassAliasPool.CLASS_ALIASES.forName((CharSequence)TestEnum.class.getName().toLowerCase()));
    }

    @Test
    public void banned() {
        for (int i = 0; i < 2; ++i) {
            Assert.assertThrows(ClassNotFoundRuntimeException.class, () -> ClassAliasPool.CLASS_ALIASES.forName((CharSequence)"com.sun.xml.internal.bind.v2.runtime.unmarshaller.Base64Data"));
            Assert.assertThrows(ClassNotFoundRuntimeException.class, () -> ClassAliasPool.CLASS_ALIASES.forName((CharSequence)"com.sun.istack.internal.ByteArrayDataSource"));
            Assert.assertThrows(ClassNotFoundRuntimeException.class, () -> ClassAliasPool.CLASS_ALIASES.forName((CharSequence)"com.oracle.webservices.internal.api.databinding.DatabindingFactory"));
            Assert.assertThrows(ClassNotFoundRuntimeException.class, () -> ClassAliasPool.CLASS_ALIASES.forName((CharSequence)"jdk.internal.util.xml.SAXParser"));
            Assert.assertThrows(ClassNotFoundRuntimeException.class, () -> ClassAliasPool.CLASS_ALIASES.forName((CharSequence)"sun.corba.SharedSecrets"));
        }
    }

    static enum TestEnum {
        FOO{

            @Override
            void foo() {
            }
        }
        ,
        BAR;


        void foo() {
        }
    }
}

