/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.pool;

import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.core.pool.ClassLookup;
import net.openhft.chronicle.core.util.ClassNotFoundRuntimeException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ClassLookupTest {
    private ClassLookup classLookup = ClassAliasPool.CLASS_ALIASES;

    ClassLookupTest() {
    }

    @Test
    void testClassLookupByName() {
        Class clazz = this.classLookup.forName((CharSequence)"java.lang.String");
        Assertions.assertEquals(String.class, (Object)clazz);
    }

    @Test
    void testAddingAliasAndLookupByAlias() {
        this.classLookup.addAlias(String.class, "StringAlias");
        Class clazz = this.classLookup.forName((CharSequence)"StringAlias");
        Assertions.assertEquals(String.class, (Object)clazz);
    }

    @Test
    void testImmutabilityOfWrappedInstance() {
        ClassLookup wrapped = this.classLookup.wrap();
        wrapped.addAlias(String.class, "StringAlias");
        Assertions.assertThrows(ClassNotFoundRuntimeException.class, () -> this.classLookup.forName((CharSequence)"StringAlias"));
    }

    @Test
    void testLookupOfLambdaClass() {
        Runnable lambda = () -> {};
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.classLookup.nameFor(lambda.getClass()));
    }
}

